"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePolicyWizard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
var _steps = require("./steps");
var _create_policy_context = require("./create_policy_context");
var _api = require("../../services/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/enrich_policy_create/create_policy_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CONFIGURATION = 1;
const FIELD_SELECTION = 2;
const CREATE = 3;
const CreatePolicyWizard = () => {
  const {
    history,
    services: {
      notificationService
    }
  } = (0, _app_context.useAppContext)();
  const {
    draft,
    completionState
  } = (0, _create_policy_context.useCreatePolicyContext)();
  const [currentStep, setCurrentStep] = (0, _react.useState)(CONFIGURATION);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [createError, setCreateError] = (0, _react.useState)(null);
  const getStepStatus = (0, _react.useCallback)(forStep => {
    if (currentStep === forStep) {
      return 'current';
    }
    return 'incomplete';
  }, [currentStep]);
  const onSubmit = (0, _react.useCallback)(async executePolicyAfterCreation => {
    setIsLoading(true);
    const {
      error,
      data
    } = await (0, _api.createEnrichPolicy)(draft, executePolicyAfterCreation);
    setIsLoading(false);
    if (data) {
      const toastMessage = executePolicyAfterCreation ? _i18n.i18n.translate('xpack.idxMgmt.enrichPoliciesCreate.createAndExecuteNotificationMessage', {
        defaultMessage: 'Created and executed policy: {policyName}',
        values: {
          policyName: draft.name
        }
      }) : _i18n.i18n.translate('xpack.idxMgmt.enrichPoliciesCreate.createNotificationMessage', {
        defaultMessage: 'Created policy: {policyName}',
        values: {
          policyName: draft.name
        }
      });
      notificationService.showSuccessToast(toastMessage);
    }
    if (error) {
      setCreateError(error);
      return;
    }
    history.push('/enrich_policies');
  }, [draft, history, setIsLoading, setCreateError, notificationService]);
  const changeCurrentStepTo = (0, _react.useCallback)(step => {
    setCurrentStep(step);
    setCreateError(null);
  }, [setCurrentStep, setCreateError]);
  const stepDefinitions = (0, _react.useMemo)(() => [{
    step: CONFIGURATION,
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.configurationStepLabel', {
      defaultMessage: 'Configuration'
    }),
    status: completionState.configurationStep ? 'complete' : getStepStatus(CONFIGURATION),
    children: currentStep === CONFIGURATION && /*#__PURE__*/_react.default.createElement(_steps.ConfigurationStep, {
      onNext: () => changeCurrentStepTo(FIELD_SELECTION),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    })
  }, {
    step: FIELD_SELECTION,
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.fieldSelectionStepLabel', {
      defaultMessage: 'Field selection'
    }),
    status: completionState.fieldsSelectionStep ? 'complete' : getStepStatus(FIELD_SELECTION),
    children: currentStep === FIELD_SELECTION && /*#__PURE__*/_react.default.createElement(_steps.FieldSelectionStep, {
      onNext: () => changeCurrentStepTo(CREATE),
      onBack: () => changeCurrentStepTo(CONFIGURATION),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })
  }, {
    step: CREATE,
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStepLabel', {
      defaultMessage: 'Create'
    }),
    status: currentStep === CREATE ? 'current' : 'incomplete',
    children: currentStep === CREATE && /*#__PURE__*/_react.default.createElement(_steps.CreateStep, {
      onSubmit: onSubmit,
      isLoading: isLoading,
      onBack: () => changeCurrentStepTo(FIELD_SELECTION),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    })
  }], [currentStep, changeCurrentStepTo, completionState, getStepStatus, isLoading, onSubmit]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, createError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.errorTitle', {
      defaultMessage: 'Unable to create your policy'
    }),
    color: "danger",
    iconType: "error",
    "data-test-subj": "errorWhenCreatingCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, (createError === null || createError === void 0 ? void 0 : createError.message) || (createError === null || createError === void 0 ? void 0 : createError.error))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: stepDefinitions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }));
};
exports.CreatePolicyWizard = CreatePolicyWizard;