"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BooleanType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lib = require("../../../../lib");
var _shared_imports = require("../../../../shared_imports");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/field_types/boolean_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultToggleValue = (param, field) => {
  switch (param) {
    case 'meta':
    case 'boost':
      {
        return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
      }
    case 'null_value':
      {
        return field.null_value !== undefined;
      }
    default:
      return false;
  }
};
const nullValueOptions = [{
  value: 0,
  text: `"true"`
}, {
  value: 1,
  text: 'true'
}, {
  value: 2,
  text: `"false"`
}, {
  value: 3,
  text: 'false'
}];
const BooleanType = ({
  field,
  kibanaVersion
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.IndexParameter, {
    hasIndexOptions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.DocValuesParameter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.NullValueParameter, {
    defaultToggleValue: getDefaultToggleValue('null_value', field.source),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.booleanNullValueFieldDescription', {
      defaultMessage: 'Replace explicit null values with a specific boolean value so that it can be indexed and searched.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "null_value",
    config: (0, _lib.getFieldConfig)('null_value_boolean'),
    component: _shared_imports.SelectField,
    componentProps: {
      euiFieldProps: {
        options: nullValueOptions,
        fullWidth: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_field_parameters.StoreParameter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }), kibanaVersion.major < 8 && /*#__PURE__*/_react.default.createElement(_field_parameters.BoostParameter, {
    defaultToggleValue: getDefaultToggleValue('boost', field.source),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })));
};
exports.BooleanType = BooleanType;