"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WillUseFallbackTierUsingNodeAttributesNotice = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _no_custom_attributes_messages = require("./no_custom_attributes_messages");
var _node_role_to_fallback_tier_map = require("./node_role_to_fallback_tier_map");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/data_tier_allocation_field/components/will_fallback_nodes_notice.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WillUseFallbackTierUsingNodeAttributesNotice = ({
  phase,
  targetNodeRole
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "willUseFallbackTierUsingNodeAttributesNotice",
    title: _no_custom_attributes_messages.noCustomAttributesTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.dataTier.willUseFallbackTierUsingNodeAttributesDescription', {
    defaultMessage: 'No {phase} nodes available. Data will be allocated to the {fallbackTier} tier.',
    values: {
      phase,
      fallbackTier: _node_role_to_fallback_tier_map.nodeRoleToFallbackTierMap[targetNodeRole]
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  },
  // @ts-expect-error Type '({ docLinks }: Props) => React.JSX.Element' is not assignable to type 'ReactNode'.
  _no_custom_attributes_messages.nodeAllocationMigrationGuidance));
};
exports.WillUseFallbackTierUsingNodeAttributesNotice = WillUseFallbackTierUsingNodeAttributesNotice;