"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureDirectory = ensureDirectory;
exports.ensureDirectorySync = ensureDirectorySync;
exports.getSafePath = getSafePath;
var _fs = require("fs");
var _path = require("path");
var _repoInfo = require("@kbn/repo-info");
var _validations = require("./validations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_PATH = (0, _path.join)(_repoInfo.REPO_ROOT, 'data');
function getSafePath(name, volume) {
  const fullPath = volume ? (0, _path.join)(DATA_PATH, volume, name) : (0, _path.join)(DATA_PATH, name);
  const resolvedPath = (0, _validations.validateNoPathTraversal)(fullPath);
  (0, _validations.validateFileExtension)(fullPath);
  const alias = volume ? `disk:data/${volume}/${name}` : `disk:data/${name}`;
  return {
    fullPath: resolvedPath,
    alias
  };
}
async function ensureDirectory(path) {
  const dir = (0, _path.dirname)(path);
  if ((0, _fs.existsSync)(dir)) {
    return;
  }
  await _fs.promises.mkdir(dir, {
    recursive: true
  });
}
function ensureDirectorySync(path) {
  const dir = (0, _path.dirname)(path);
  if ((0, _fs.existsSync)(dir)) {
    return;
  }
  (0, _fs.mkdirSync)(dir, {
    recursive: true
  });
}