"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTourManager = exports.TourManagerProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/hooks/use_tour_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TourManagerContext = /*#__PURE__*/(0, _react.createContext)(null);
const TourManagerProvider = ({
  children
}) => {
  const [activeTour, setActiveTour] = (0, _react.useState)(null);
  return /*#__PURE__*/_react.default.createElement(TourManagerContext.Provider, {
    value: {
      activeTour,
      setActiveTour
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, children);
};

/**
 * Hook to manage tour coordination across Fleet components.
 * Ensures only one tour is displayed at a time to prevent overlap.
 */
exports.TourManagerProvider = TourManagerProvider;
const useTourManager = () => {
  const context = (0, _react.useContext)(TourManagerContext);
  if (!context) {
    // Fallback behavior when context is not available
    return {
      activeTour: null,
      setActiveTour: () => {}
    };
  }
  return context;
};
exports.useTourManager = useTourManager;