"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicySelectionStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _agent_policy_select_create = require("../agent_policy_select_create");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/agent_policy_selection_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentPolicySelectionStep = ({
  agentPolicies,
  selectedPolicy,
  setSelectedPolicyId,
  selectedApiKeyId,
  setSelectedAPIKeyId,
  excludeFleetServer,
  refreshAgentPolicies
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepChooseAgentPolicyTitle', {
      defaultMessage: 'What type of host do you want to monitor?'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_agent_policy_select_create.SelectCreateAgentPolicy, {
      agentPolicies: agentPolicies,
      selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
      setSelectedPolicyId: setSelectedPolicyId,
      withKeySelection: setSelectedAPIKeyId ? true : false,
      selectedApiKeyId: selectedApiKeyId,
      onKeyChange: setSelectedAPIKeyId,
      refreshAgentPolicies: refreshAgentPolicies,
      excludeFleetServer: excludeFleetServer,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }))
  };
};
exports.AgentPolicySelectionStep = AgentPolicySelectionStep;