"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParams = exports.categoryExists = exports.EPMHomePage = void 0;
Object.defineProperty(exports, "mapToCard", {
  enumerable: true,
  get: function () {
    return _card_utils.mapToCard;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../constants");
var _layouts = require("../../../../layouts");
var _services = require("../../../../services");
var _installed_integrations = require("../installed_integrations");
var _hooks = require("../../../../hooks");
var _installed_packages = require("./installed_packages");
var _available_packages = require("./available_packages");
var _card_utils = require("./card_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/home/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getParams = (params, search) => {
  const {
    category,
    subcategory
  } = params;
  const selectedCategory = category || '';
  const queryParams = new URLSearchParams(search);
  const searchParam = queryParams.get(_constants2.INTEGRATIONS_SEARCH_QUERYPARAM) || '';
  const onlyAgentlessParam = queryParams.get(_constants2.INTEGRATIONS_ONLY_AGENTLESS_QUERYPARAM) === 'true';
  return {
    selectedCategory,
    searchParam,
    selectedSubcategory: subcategory,
    onlyAgentless: onlyAgentlessParam
  };
};
exports.getParams = getParams;
const categoryExists = (category, categories) => {
  return categories.some(c => c.id === category);
};
exports.categoryExists = categoryExists;
const EPMHomePage = () => {
  var _ExperimentalFeatures, _ExperimentalFeatures2, _settings$item$prerel;
  const config = (0, _hooks.useConfig)();
  const {
    application
  } = (0, _hooks.useStartServices)();
  if (config.integrationsHomeOverride) {
    application.navigateToUrl(config.integrationsHomeOverride);
  }
  const authz = (0, _hooks.useAuthz)();
  const isAuthorizedToFetchSettings = authz.fleet.readSettings;
  const {
    data: settings,
    isFetchedAfterMount: isSettingsFetched
  } = (0, _hooks.useGetSettingsQuery)({
    enabled: isAuthorizedToFetchSettings
  });
  const installedIntegrationsTabularUI = (_ExperimentalFeatures = (_ExperimentalFeatures2 = _services.ExperimentalFeaturesService.get()) === null || _ExperimentalFeatures2 === void 0 ? void 0 : _ExperimentalFeatures2.installedIntegrationsTabularUI) !== null && _ExperimentalFeatures !== void 0 ? _ExperimentalFeatures : false;
  const prereleaseIntegrationsEnabled = (_settings$item$prerel = settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled) !== null && _settings$item$prerel !== void 0 ? _settings$item$prerel : false;
  const shouldFetchPackages = !isAuthorizedToFetchSettings || isSettingsFetched;
  // loading packages to find installed ones
  const {
    data: allPackages,
    isLoading
  } = (0, _hooks.useGetPackagesQuery)({
    prerelease: prereleaseIntegrationsEnabled
  }, {
    enabled: shouldFetchPackages
  });
  const installedPackages = (0, _react.useMemo)(() => ((allPackages === null || allPackages === void 0 ? void 0 : allPackages.items) || []).filter(pkg => pkg.status === _constants.installationStatuses.Installed || pkg.status === _constants.installationStatuses.InstallFailed), [allPackages]);
  const unverifiedPackageCount = (0, _react.useMemo)(() => installedPackages.filter(pkg => {
    var _pkg$installationInfo;
    return ((_pkg$installationInfo = pkg.installationInfo) === null || _pkg$installationInfo === void 0 ? void 0 : _pkg$installationInfo.verification_status) && pkg.installationInfo.verification_status === 'unverified';
  }).length, [installedPackages]);
  const upgradeablePackageCount = (0, _react.useMemo)(() => installedPackages.filter(_services.isPackageUpdatable).length, [installedPackages]);
  const notificationsBySection = {
    manage: unverifiedPackageCount + upgradeablePackageCount
  };
  if (!shouldFetchPackages) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integrations_installed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "manage",
    notificationsBySection: notificationsBySection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, installedIntegrationsTabularUI ? /*#__PURE__*/_react.default.createElement(_installed_integrations.InstalledIntegrationsPage, {
    prereleaseIntegrationsEnabled: prereleaseIntegrationsEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_installed_packages.InstalledPackages, {
    installedPackages: installedPackages,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integrations_all,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "browse",
    notificationsBySection: notificationsBySection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_available_packages.AvailablePackages, {
    prereleaseIntegrationsEnabled: prereleaseIntegrationsEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }))));
};
exports.EPMHomePage = EPMHomePage;