"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmIncomingDataTimeout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _bottom_bar = require("./bottom_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/multi_page_layout/components/confirm_incoming_data_timeout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmIncomingDataTimeout = ({
  agentIds,
  troubleshootLink,
  packageInfo
}) => {
  var _packageInfo$title;
  const discoverLogsLink = (0, _hooks.useGetDiscoverLogsLinkForAgents)(agentIds);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.timeout.title",
    defaultMessage: "Confirming data is taking longer than expected",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.timeout.body",
    defaultMessage: "If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you're having trouble, see our {troubleshootLink}, or you may check later by viewing {discoverLink}.",
    values: {
      troubleshootLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: troubleshootLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingData.timeout.troubleshootLink",
        defaultMessage: "troubleshooting guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 17
        }
      })),
      discoverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: discoverLogsLink !== null && discoverLogsLink !== void 0 ? discoverLogsLink : '',
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingData.timeout.discoverLink",
        defaultMessage: "{integration} logs in Discover",
        values: {
          integration: (_packageInfo$title = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) !== null && _packageInfo$title !== void 0 ? _packageInfo$title : ''
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_bottom_bar.NotObscuredByBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_bottom_bar.AgentDataTimedOutBottomBar, {
    agentIds: agentIds,
    troubleshootLink: troubleshootLink,
    integration: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
exports.ConfirmIncomingDataTimeout = ConfirmIncomingDataTimeout;