"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithPermissionsAndSetup = exports.FleetAppContext = exports.AppRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _css = require("@emotion/css");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("@kbn/kibana-react-plugin/common");
var _hooks = require("../integrations/hooks");
var _use_space_settings_context = require("../../hooks/use_space_settings_context");
var _error = require("../../layouts/error");
var _hooks2 = require("./hooks");
var _components = require("./components");
var _constants = require("./constants");
var _agent_policy = require("./sections/agent_policy");
var _data_stream = require("./sections/data_stream");
var _agents = require("./sections/agents");
var _create_package_policy_page = require("./sections/agent_policy/create_package_policy_page");
var _enrollment_token_list_page = require("./sections/agents/enrollment_token_list_page");
var _uninstall_token_list_page = require("./sections/agents/uninstall_token_list_page");
var _settings = require("./sections/settings");
var _debug = require("./sections/debug");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FEEDBACK_URL = 'https://ela.st/fleet-feedback';
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      networkMode: 'always'
    },
    mutations: {
      networkMode: 'always'
    }
  }
});
const WithPermissionsAndSetup = exports.WithPermissionsAndSetup = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  (0, _hooks2.useBreadcrumbs)('base');
  const core = (0, _hooks2.useStartServices)();
  const {
    notifications
  } = core;
  const authz = (0, _hooks2.useAuthz)();
  const hasAnyFleetReadPrivileges = authz.fleet.readEnrollmentTokens || authz.fleet.readAgents || authz.fleet.readAgentPolicies || authz.fleet.readSettings;
  const hasIntegrationsCreateOrUpdatePrivileges = authz.integrations.all;
  const [isPermissionsLoading, setIsPermissionsLoading] = (0, _react.useState)(false);
  const [permissionsError, setPermissionsError] = (0, _react.useState)();
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [initializationError, setInitializationError] = (0, _react.useState)(null);
  const isAddIntegrationsPath = !!(0, _reactRouterDom.useRouteMatch)(_constants.FLEET_ROUTING_PATHS.add_integration_to_policy);
  const isDebugPath = !!(0, _reactRouterDom.useRouteMatch)(_constants.FLEET_ROUTING_PATHS.debug);
  (0, _react.useEffect)(() => {
    (async () => {
      setIsPermissionsLoading(false);
      setPermissionsError(undefined);
      setIsInitialized(false);
      setInitializationError(null);
      try {
        var _permissionsResponse$;
        setIsPermissionsLoading(true);
        const permissionsResponse = await (0, _hooks2.sendGetPermissionsCheck)();
        setIsPermissionsLoading(false);
        if ((_permissionsResponse$ = permissionsResponse.data) !== null && _permissionsResponse$ !== void 0 && _permissionsResponse$.success) {
          try {
            var _setupResponse$data, _setupResponse$data$n;
            const setupResponse = await (0, _hooks2.sendSetup)();
            if (setupResponse.error) {
              setInitializationError(setupResponse.error);
            }
            if ((_setupResponse$data = setupResponse.data) !== null && _setupResponse$data !== void 0 && (_setupResponse$data$n = _setupResponse$data.nonFatalErrors) !== null && _setupResponse$data$n !== void 0 && _setupResponse$data$n.length) {
              notifications.toasts.addError(setupResponse.data.nonFatalErrors[0], {
                title: _i18n.i18n.translate('xpack.fleet.setup.uiPreconfigurationErrorTitle', {
                  defaultMessage: 'Configuration error'
                })
              });
            }
            if (!hasAnyFleetReadPrivileges) {
              setPermissionsError('MISSING_PRIVILEGES');
            }
            if (!hasIntegrationsCreateOrUpdatePrivileges && isAddIntegrationsPath) {
              setPermissionsError('MISSING_PRIVILEGES');
            }
          } catch (err) {
            setInitializationError(err);
          }
          setIsInitialized(true);
        } else {
          var _permissionsResponse$2;
          setPermissionsError(((_permissionsResponse$2 = permissionsResponse.data) === null || _permissionsResponse$2 === void 0 ? void 0 : _permissionsResponse$2.error) || 'REQUEST_ERROR');
        }
      } catch (err) {
        setPermissionsError('REQUEST_ERROR');
      }
    })();
  }, [notifications.toasts, hasAnyFleetReadPrivileges, hasIntegrationsCreateOrUpdatePrivileges, isAddIntegrationsPath]);
  if (isPermissionsLoading || permissionsError) {
    return /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
      isAddIntegrationsPath: isAddIntegrationsPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 7
      }
    }, isPermissionsLoading ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
      callingApplication: "Fleet",
      error: permissionsError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }));
  }
  // Debug page moved outside of initialization to allow debugging when setup failed
  if (isDebugPath) {
    return /*#__PURE__*/_react.default.createElement(_debug.DebugPage, {
      setupError: initializationError,
      isInitialized: isInitialized,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 12
      }
    });
  }
  if (!isInitialized || initializationError) {
    return /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
      isAddIntegrationsPath: isAddIntegrationsPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }, initializationError ? /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.initializationErrorMessageTitle",
        defaultMessage: "Unable to initialize Fleet",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      }),
      error: initializationError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_components.FleetSetupLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});

/**
 * Fleet Application context all the way down to the Router, but with no permissions or setup checks
 * and no routes defined
 */
const FleetAppContext = exports.FleetAppContext = /*#__PURE__*/(0, _react.memo)(({
  children,
  startServices,
  config,
  history,
  kibanaVersion,
  extensions,
  routerHistory: _routerHistory,
  fleetStatus
}) => {
  const XXL_BREAKPOINT = 1600;
  const isDarkMode = (0, _useObservable.default)(startServices.theme.theme$, startServices.theme.getTheme()).darkMode;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    theme: startServices.theme,
    modify: {
      breakpoint: {
        xxl: XXL_BREAKPOINT
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: startServices.application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...startServices
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.ConfigContext.Provider, {
    value: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.KibanaVersionContext.Provider, {
    value: kibanaVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_hooks2.UIExtensionsContext.Provider, {
    value: extensions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.FleetStatusProvider, {
    defaultFleetStatus: fleetStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_use_space_settings_context.SpaceSettingsContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks.PackageInstallProvider, {
    startServices: startServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_hooks2.FlyoutContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 31
    }
  }, children)))))))))))));
});
const FleetTopNav = /*#__PURE__*/(0, _react.memo)(({
  setHeaderActionMenu,
  isReadOnly
}) => {
  const services = (0, _hooks2.useStartServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const readOnlyBtnClass = _react.default.useMemo(() => {
    return (0, _css.css)`
        color: ${euiTheme.colors.textParagraph};
      `;
  }, [euiTheme]);
  const {
    TopNavMenu
  } = services.navigation.ui;
  const topNavConfig = [];
  if (isReadOnly) {
    topNavConfig.push({
      label: _i18n.i18n.translate('xpack.fleet.appNavigation.readOnlyBtn', {
        defaultMessage: 'Read-only'
      }),
      disableButton: true,
      className: readOnlyBtnClass,
      iconType: 'glasses',
      tooltip: _i18n.i18n.translate('xpack.fleet.appNavigation.readOnlyTooltip', {
        defaultMessage: "You can view most Fleet settings, but your current privileges don't allow you to perform all actions."
      }),
      run: () => {}
    });
  }
  topNavConfig.push({
    label: _i18n.i18n.translate('xpack.fleet.appNavigation.giveFeedbackButton', {
      defaultMessage: 'Give feedback'
    }),
    iconType: 'popout',
    run: () => window.open(FEEDBACK_URL)
  });
  return /*#__PURE__*/_react.default.createElement(TopNavMenu, {
    appName: _i18n.i18n.translate('xpack.fleet.appTitle', {
      defaultMessage: 'Fleet'
    }),
    config: topNavConfig,
    setMenuMountPoint: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  });
});
const AppLayout = ({
  children,
  setHeaderActionMenu,
  isReadOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FleetTopNav, {
    setHeaderActionMenu: setHeaderActionMenu,
    isReadOnly: isReadOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }), children);
};
const AppRoutes = exports.AppRoutes = /*#__PURE__*/(0, _react.memo)(({
  setHeaderActionMenu
}) => {
  var _fleetStatus$missingR;
  const flyoutContext = (0, _hooks2.useFlyoutContext)();
  const fleetStatus = (0, _hooks2.useFleetStatus)();
  const authz = (0, _hooks2.useAuthz)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agents,
    key: _constants.FLEET_ROUTING_PATHS.agents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 11
    }
  }, authz.fleet.readAgents ? /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    isReadOnly: !authz.fleet.allAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_agents.AgentsApp, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
    isAddIntegrationsPath: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
    callingApplication: "Fleet",
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agents Read",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 11
    }
  }, authz.fleet.readAgentPolicies ? /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    isReadOnly: !authz.fleet.allAgentPolicies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_policy.AgentPolicyApp, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
    isAddIntegrationsPath: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
    callingApplication: "Fleet",
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agent policies Read",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.enrollment_tokens,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 11
    }
  }, authz.fleet.allAgents ? /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_enrollment_token_list_page.EnrollmentTokenListPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
    isAddIntegrationsPath: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
    callingApplication: "Fleet",
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agents All",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.uninstall_tokens,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 11
    }
  }, authz.fleet.allAgents ? /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_uninstall_token_list_page.UninstallTokenListPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
    isAddIntegrationsPath: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
    callingApplication: "Fleet",
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agents All",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.data_streams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_data_stream.DataStreamApp, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.settings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 11
    }
  }, authz.fleet.readSettings ? /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    isReadOnly: !authz.fleet.allSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_settings.SettingsApp, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_error.ErrorLayout, {
    isAddIntegrationsPath: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(AppLayout, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_error.PermissionsError, {
    callingApplication: "Fleet",
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Settings Read",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.add_integration_to_policy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_create_package_policy_page.CreatePackagePolicyPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: ({
      location
    }) => {
      // BWC < 7.15 Fleet was using a hash router: redirect old routes using hash
      const shouldRedirectHash = location.pathname === '' && location.hash.length > 0;
      if (!shouldRedirectHash) {
        // Redirect to the first authorized tab
        const redirectTo = authz.fleet.readAgents ? _constants.FLEET_ROUTING_PATHS.agents : authz.fleet.readAgentPolicies ? _constants.FLEET_ROUTING_PATHS.policies : _constants.FLEET_ROUTING_PATHS.settings;
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: redirectTo,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 460,
            columnNumber: 24
          }
        });
      }
      const pathname = location.hash.replace(/^#(\/fleet)?/, '');
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          ...location,
          pathname,
          hash: undefined
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 465,
          columnNumber: 17
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 11
    }
  })), flyoutContext.isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 477,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
    defaultMode: fleetStatus.isReady && !((_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 && _fleetStatus$missingR.includes('fleet_server')) ? 'managed' : 'standalone',
    isIntegrationFlow: true,
    onClose: () => flyoutContext.closeEnrollmentFlyout(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 13
    }
  })), flyoutContext.isFleetServerFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 490,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.FleetServerFlyout, {
    onClose: () => flyoutContext.closeFleetServerFlyout(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 13
    }
  })));
});