"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionViewMetricWithLens = exports.AnalyticsCollectionViewMetric = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _with_lens_data = require("../../../hoc/with_lens_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_overview/analytics_collection_metric.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var MetricStatus = /*#__PURE__*/function (MetricStatus) {
  MetricStatus["INCREASE"] = "increase";
  MetricStatus["DECREASE"] = "decrease";
  MetricStatus["CONSTANT"] = "constant";
  return MetricStatus;
}(MetricStatus || {});
const getMetricTheme = (euiTheme, status) => ({
  [MetricStatus.DECREASE]: {
    color: _uiTheme.euiThemeVars.euiColorVis7,
    icon: 'sortDown'
  },
  [MetricStatus.CONSTANT]: {
    color: euiTheme.colors.darkShade,
    icon: 'minus'
  },
  [MetricStatus.INCREASE]: {
    color: _uiTheme.euiThemeVars.euiColorVis0,
    icon: 'sortUp'
  }
})[status];
const getMetricStatus = metric => {
  if (metric > 0) return MetricStatus.INCREASE;
  if (metric < 0) return MetricStatus.DECREASE;
  return MetricStatus.CONSTANT;
};
const AnalyticsCollectionViewMetric = ({
  isLoading,
  isSelected,
  metric,
  name,
  onClick,
  secondaryMetric
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [displayMetric, setDisplayMetric] = (0, _react.useState)(metric);
  const [displaySecondaryMetric, setDisplaySecondaryMetric] = (0, _react.useState)(secondaryMetric);
  (0, _react.useEffect)(() => {
    if (metric !== null) {
      setDisplayMetric(metric);
    }
  }, [metric]);
  (0, _react.useEffect)(() => {
    if (secondaryMetric !== null) {
      setDisplaySecondaryMetric(metric);
    }
  }, [secondaryMetric]);
  const {
    icon,
    color
  } = getMetricTheme(euiTheme, getMetricStatus(displaySecondaryMetric || 0));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: true,
    hasBorder: true,
    hasShadow: false,
    onClick: onClick,
    color: isSelected ? 'primary' : 'plain',
    css: isSelected ? (0, _react2.css)`
              border: 1px solid ${euiTheme.colors.primary};
              position: relative;
              overflow: hidden;
            ` : (0, _react2.css)`
              position: relative;
              overflow: hidden;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "success",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, displaySecondaryMetric === null ? _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collection.notAvailableLabel', {
    defaultMessage: 'N/A'
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 19
    }
  }), displaySecondaryMetric + '%')))), isLoading && displayMetric === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    height: euiTheme.size.xl,
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isSelected ? euiTheme.colors.primaryText : color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, displayMetric === null ? _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collection.notAvailableLabel', {
    defaultMessage: 'N/A'
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
    value: displayMetric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  })))));
};
exports.AnalyticsCollectionViewMetric = AnalyticsCollectionViewMetric;
const LENS_LAYERS = {
  metrics: {
    hitsTotal: 'hitsTotal',
    id: 'metrics',
    percentage: 'percentage'
  }
};
const initialValues = {
  isLoading: true,
  metric: null,
  secondaryMetric: null
};
const AnalyticsCollectionViewMetricWithLens = exports.AnalyticsCollectionViewMetricWithLens = (0, _with_lens_data.withLensData)(AnalyticsCollectionViewMetric, {
  dataLoadTransform: (isLoading, adapters) => {
    var _adapters$tables$tabl, _adapters$tables, _adapters$tables$tabl2, _adapters$tables$tabl3, _adapters$tables$tabl4, _adapters$tables$tabl5, _adapters$tables2, _adapters$tables2$tab, _adapters$tables2$tab2, _adapters$tables2$tab3;
    return isLoading || !adapters ? initialValues : {
      isLoading,
      metric: (_adapters$tables$tabl = (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : (_adapters$tables$tabl2 = _adapters$tables.tables[LENS_LAYERS.metrics.id]) === null || _adapters$tables$tabl2 === void 0 ? void 0 : (_adapters$tables$tabl3 = _adapters$tables$tabl2.rows) === null || _adapters$tables$tabl3 === void 0 ? void 0 : (_adapters$tables$tabl4 = _adapters$tables$tabl3[0]) === null || _adapters$tables$tabl4 === void 0 ? void 0 : _adapters$tables$tabl4[LENS_LAYERS.metrics.hitsTotal]) !== null && _adapters$tables$tabl !== void 0 ? _adapters$tables$tabl : null,
      secondaryMetric: (_adapters$tables$tabl5 = (_adapters$tables2 = adapters.tables) === null || _adapters$tables2 === void 0 ? void 0 : (_adapters$tables2$tab = _adapters$tables2.tables[LENS_LAYERS.metrics.id]) === null || _adapters$tables2$tab === void 0 ? void 0 : (_adapters$tables2$tab2 = _adapters$tables2$tab.rows) === null || _adapters$tables2$tab2 === void 0 ? void 0 : (_adapters$tables2$tab3 = _adapters$tables2$tab2[0]) === null || _adapters$tables2$tab3 === void 0 ? void 0 : _adapters$tables2$tab3[LENS_LAYERS.metrics.percentage]) !== null && _adapters$tables$tabl5 !== void 0 ? _adapters$tables$tabl5 : null
    };
  },
  getAttributes: (dataView, props) => {
    const percentageFormula = `round((${props.getFormula()}/${props.getFormula('previous')}-1) * 100)`;
    const hitsTotalFormula = props.getFormula();
    const metric = {
      columnOrder: [LENS_LAYERS.metrics.percentage, LENS_LAYERS.metrics.hitsTotal],
      columns: {
        [LENS_LAYERS.metrics.percentage]: {
          dataType: 'number',
          isBucketed: false,
          label: percentageFormula,
          operationType: 'formula',
          params: {
            formula: percentageFormula,
            isFormulaBroken: false
          },
          references: []
        },
        [LENS_LAYERS.metrics.hitsTotal]: {
          dataType: 'number',
          isBucketed: false,
          label: hitsTotalFormula,
          operationType: 'formula',
          params: {
            formula: hitsTotalFormula,
            isFormulaBroken: false
          },
          references: []
        }
      }
    };
    return {
      references: [{
        id: dataView.id,
        name: 'indexpattern-datasource-current-indexpattern',
        type: 'index-pattern'
      }, {
        id: dataView.id,
        name: `indexpattern-datasource-layer-${LENS_LAYERS.metrics.id}`,
        type: 'index-pattern'
      }],
      state: {
        datasourceStates: {
          formBased: {
            layers: {
              [LENS_LAYERS.metrics.id]: metric
            }
          }
        },
        filters: [],
        query: {
          language: 'kuery',
          query: ''
        },
        visualization: {
          layerId: [LENS_LAYERS.metrics.id],
          layerType: 'data',
          layers: [],
          metricAccessor: LENS_LAYERS.metrics.hitsTotal,
          secondaryMetricAccessor: LENS_LAYERS.metrics.percentage
        }
      },
      title: '',
      visualizationType: 'lnsMetric'
    };
  },
  initialValues
});