"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDepreciatedInternalApiResponse = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Depreciated: Returns a (placeholder) AttackDiscoveryResponse for API compatibility
 * with the depreciated internal API. This placeholder will be removed, along with the
 * internal API, in a future release.
 */
const generateDepreciatedInternalApiResponse = () => {
  const now = new Date().toISOString();
  const id = (0, _uuid.v4)();
  return {
    alertsContextCount: 0,
    apiConfig: {
      actionTypeId: '',
      connectorId: ''
    },
    attackDiscoveries: [],
    averageIntervalMs: 0,
    backingIndex: '',
    createdAt: now,
    generationIntervals: [],
    id,
    lastViewedAt: now,
    namespace: '',
    status: 'running',
    timestamp: now,
    updatedAt: now,
    users: []
  };
};
exports.generateDepreciatedInternalApiResponse = generateDepreciatedInternalApiResponse;