"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGraphInputOverrides = void 0;
var _example_input = require("../../example_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses input from an LangSmith dataset example to get the graph input overrides
 */
const getGraphInputOverrides = outputs => {
  var _ExampleInputWithOver, _validatedInput$anony, _validatedInput$insig;
  const validatedInput = (_ExampleInputWithOver = _example_input.ExampleInputWithOverrides.safeParse(outputs).data) !== null && _ExampleInputWithOver !== void 0 ? _ExampleInputWithOver : {}; // safeParse removes unknown properties

  const {
    replacements,
    overrides
  } = validatedInput;

  // Fallback to and rename the root level legacy properties `anonymizedAlerts`,
  // and `attackDiscoveries` to the new graph property names:
  const anonymizedDocuments = (_validatedInput$anony = validatedInput.anonymizedDocuments) !== null && _validatedInput$anony !== void 0 ? _validatedInput$anony : validatedInput.anonymizedAlerts;
  const insights = (_validatedInput$insig = validatedInput.insights) !== null && _validatedInput$insig !== void 0 ? _validatedInput$insig : validatedInput.attackDiscoveries;

  // return all overrides at the root level:
  return {
    anonymizedDocuments,
    insights,
    replacements,
    ...overrides // bring all other overrides to the root level
  };
};
exports.getGraphInputOverrides = getGraphInputOverrides;