"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKubernetesContainerLogsDataSourceProfileProvider = exports.KUBERNETES_CONTAINER_LOGS_RECOMMENDED_FIELD_NAMES = void 0;
var _extend_profile_provider = require("../../../extend_profile_provider");
var _accessors = require("../accessors");
var _consts = require("../consts");
var _create_resolve = require("./create_resolve");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const KUBERNETES_CONTAINER_LOGS_RECOMMENDED_FIELD_NAMES = exports.KUBERNETES_CONTAINER_LOGS_RECOMMENDED_FIELD_NAMES = ['log.level', 'message', 'kubernetes.pod.name', 'kubernetes.container.name', 'kubernetes.namespace', 'orchestrator.resource.name', 'container.image.name', 'kubernetes.node.name'];
const createKubernetesContainerLogsDataSourceProfileProvider = logsDataSourceProfileProvider => (0, _extend_profile_provider.extendProfileProvider)(logsDataSourceProfileProvider, {
  profileId: 'observability-kubernetes-container-logs-data-source-profile',
  profile: {
    getDefaultAppState: (0, _accessors.createGetDefaultAppState)({
      defaultColumns: [_consts.LOG_LEVEL_COLUMN, {
        name: 'kubernetes.pod.name',
        width: 200
      }, {
        name: 'kubernetes.namespace',
        width: 200
      }, {
        name: 'orchestrator.cluster.name',
        width: 200
      }, _consts.MESSAGE_COLUMN]
    }),
    getRecommendedFields: (0, _accessors.createRecommendedFields)({
      defaultFields: KUBERNETES_CONTAINER_LOGS_RECOMMENDED_FIELD_NAMES
    })
  },
  resolve: (0, _create_resolve.createResolve)('logs-kubernetes.container_logs')
});
exports.createKubernetesContainerLogsDataSourceProfileProvider = createKubernetesContainerLogsDataSourceProfileProvider;