"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAsyncFunction = void 0;
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useAsyncFunction = (asyncFunction, initialState = {
  loading: true
}) => {
  const latestFunction = (0, _useLatest.default)(asyncFunction);
  const [state, returnFunction] = (0, _useAsyncFn.default)((...params) => latestFunction.current(...params), [latestFunction], initialState);
  const castedState = state;
  return [castedState, returnFunction];
};
exports.useAsyncFunction = useAsyncFunction;