"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalysisOverrides = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _edit_flyout = require("./edit_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/analysis_overrides.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnalysisOverrides = ({
  fileStatus,
  analyzeFileWithOverrides,
  index
}) => {
  var _fileStatus$results$f, _fileStatus$results;
  const [isEditFlyoutVisible, setIsEditFlyoutVisible] = (0, _react.useState)(false);
  const fields = Object.keys((_fileStatus$results$f = (_fileStatus$results = fileStatus.results) === null || _fileStatus$results === void 0 ? void 0 : _fileStatus$results.field_stats) !== null && _fileStatus$results$f !== void 0 ? _fileStatus$results$f : {});
  if (fileStatus.serverSettings === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.analysisSummary.overrideSettingsTooltip",
      defaultMessage: "File settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => setIsEditFlyoutVisible(true),
    iconType: "gear",
    size: "xs",
    color: "text",
    "data-test-subj": `mlFileUploadOverrideSettingsButton-${index}`,
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.analysisSummary.overrideSettingsAriaLabel', {
      defaultMessage: 'File settings'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_flyout.EditFlyout, {
    setOverrides: analyzeFileWithOverrides,
    closeEditFlyout: () => setIsEditFlyoutVisible(false),
    isFlyoutVisible: isEditFlyoutVisible,
    fileStatus: fileStatus,
    fields: fields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
};
exports.AnalysisOverrides = AnalysisOverrides;