"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentStatsTable = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _types = require("../../types");
var _expanded_row_panel = require("./expanded_row_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_expanded_row/document_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metaTableColumns = [{
  field: 'function',
  name: '',
  render: (_, metaItem) => metaItem.display,
  width: '25px',
  align: _eui.LEFT_ALIGNMENT
}, {
  field: 'value',
  name: '',
  render: v => /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 28
    }
  }, v),
  align: _eui.RIGHT_ALIGNMENT
}];
const metaTableTitle = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.fieldExpandedRow.documentStatsTable.metaTableTitle', {
  defaultMessage: 'Documents stats'
});
const DocumentStatsTable = ({
  config
}) => {
  if ((config === null || config === void 0 ? void 0 : config.stats) === undefined || config.stats.cardinality === undefined || config.stats.count === undefined || config.stats.sampleCount === undefined) return null;
  const {
    cardinality,
    count,
    sampleCount
  } = config.stats;
  const valueCount = count !== null && count !== void 0 ? count : (0, _types.isIndexBasedFieldVisConfig)(config) && config.existsInDocs === true ? undefined : 0;
  const docsPercent = valueCount !== undefined && sampleCount !== undefined ? (0, _mlNumberUtils.roundToDecimalPlace)(valueCount / sampleCount * 100) : undefined;
  const metaTableItems = [{
    function: 'count',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.documentStatsTable.countLabel",
      defaultMessage: "count",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }),
    value: count
  }, ...(docsPercent !== undefined ? [{
    function: 'percentage',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.documentStatsTable.percentageLabel",
      defaultMessage: "percentage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }),
    value: `${docsPercent}%`
  }] : []), {
    function: 'distinctValues',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.documentStatsTable.distinctValueLabel",
      defaultMessage: "distinct values",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }),
    value: cardinality
  }];
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: 'dataVisualizerDocumentStatsContent',
    className: 'dvSummaryTable__wrapper dvPanel__wrapper',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, metaTableTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: 'dvSummaryTable',
    compressed: true,
    items: metaTableItems,
    columns: metaTableColumns,
    tableCaption: metaTableTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }));
};
exports.DocumentStatsTable = DocumentStatsTable;