"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformDashboardIn = void 0;
var _common = require("@kbn/saved-objects-tagging-plugin/common");
var _transform_panels_in = require("./transform_panels_in");
var _transform_control_group_in = require("./transform_control_group_in");
var _transform_search_source_in = require("./transform_search_source_in");
var _transform_tags_in = require("./transform_tags_in");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const transformDashboardIn = ({
  dashboardState,
  incomingReferences = []
}) => {
  try {
    const {
      controlGroupInput,
      kibanaSavedObjectMeta,
      options,
      panels,
      tags,
      timeRange,
      timeRestore,
      ...rest
    } = dashboardState;
    const tagReferences = (0, _transform_tags_in.transformTagsIn)({
      tags,
      references: incomingReferences
    });

    // TODO - remove once all references are provided server side
    const nonTagIncomingReferences = incomingReferences.filter(({
      type
    }) => type !== _common.tagSavedObjectTypeName);
    const {
      panelsJSON,
      sections,
      references: panelReferences
    } = (0, _transform_panels_in.transformPanelsIn)(panels);
    const {
      searchSourceJSON,
      references: searchSourceReferences
    } = (0, _transform_search_source_in.transformSearchSourceIn)(kibanaSavedObjectMeta);
    const attributes = {
      ...rest,
      ...(controlGroupInput && {
        controlGroupInput: (0, _transform_control_group_in.transformControlGroupIn)(controlGroupInput)
      }),
      ...(options && {
        optionsJSON: JSON.stringify(options)
      }),
      ...(panels && {
        panelsJSON
      }),
      ...((sections === null || sections === void 0 ? void 0 : sections.length) && {
        sections
      }),
      timeRestore,
      ...(timeRange && timeRestore && {
        timeFrom: timeRange.from,
        timeTo: timeRange.to
      }),
      ...(kibanaSavedObjectMeta && {
        kibanaSavedObjectMeta: {
          searchSourceJSON
        }
      })
    };
    return {
      attributes,
      references: [...tagReferences, ...nonTagIncomingReferences, ...panelReferences, ...searchSourceReferences],
      error: null
    };
  } catch (e) {
    return {
      attributes: null,
      references: null,
      error: e
    };
  }
};
exports.transformDashboardIn = transformDashboardIn;