"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: _schema.dashboardGetResultSchema
      }
    }
  },
  create: {
    in: {
      options: {
        schema: _schema.dashboardCreateOptionsSchema
      },
      data: {
        schema: _configSchema.schema.object(_schema.dashboardState)
      }
    },
    out: {
      result: {
        schema: _schema.dashboardItemSchema
      }
    }
  },
  update: {
    in: {
      options: {
        schema: _schema.dashboardUpdateOptionsSchema
      },
      data: {
        schema: _schema.dashboardUpdateRequestAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: _schema.dashboardSearchOptionsSchema
      }
    }
  }
};