"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderingService = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaContextRoot = require("@kbn/react-kibana-context-root");
var _coreChromeLayoutFeatureFlags = require("@kbn/core-chrome-layout-feature-flags");
var _grid = require("@kbn/core-chrome-layout/layouts/grid");
var _legacyFixed = require("@kbn/core-chrome-layout/layouts/legacy-fixed");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/core/packages/rendering/browser-internal/src/rendering_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Renders all Core UI in a single React tree.
 *
 * @internalRemarks Currently this only renders Chrome UI. Notifications and
 * Overlays UI should be moved here as well.
 *
 * @internal
 */
class RenderingService {
  constructor() {
    (0, _defineProperty2.default)(this, "contextDeps", new _rxjs.BehaviorSubject(null));
    // Memoized context wrapper component to prevent recreation on each addContext call
    (0, _defineProperty2.default)(this, "ContextWrapper", /*#__PURE__*/_react.default.memo(({
      children
    }) => {
      /**
       * The dependencies are captured using BehaviorSubject, because we assume that Kibana plugins' start
       * methods could be called before the CoreStart services are completely settled internally. If this
       * assumption is wrong, the available dependencies are given as the initial value to `useObservable`, and
       * there is no unnecessary re-render.
       */
      const deps = (0, _useObservable.default)(this.contextDeps, this.contextDeps.getValue());
      if (!deps) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 14
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
        analytics: deps.analytics,
        executionContext: deps.executionContext,
        i18n: deps.i18n,
        theme: deps.theme,
        userProfile: deps.userProfile,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 7
        }
      }, children);
    }));
  }
  /**
   * @internal
   */
  start(deps) {
    this.contextDeps.next(deps);
    const contract = {
      renderCore: this.renderCore.bind(this),
      addContext: this.addContext.bind(this)
    };
    return contract;
  }

  /**
   * @internal
   */
  renderCore(renderCoreDeps, targetDomElement) {
    const {
      chrome,
      featureFlags
    } = renderCoreDeps;
    const layoutType = (0, _coreChromeLayoutFeatureFlags.getLayoutVersion)(featureFlags);
    const debugLayout = (0, _coreChromeLayoutFeatureFlags.getLayoutDebugFlag)(featureFlags);
    const projectSideNavVersion = (0, _coreChromeLayoutFeatureFlags.getSideNavVersion)(featureFlags);
    const startServices = this.contextDeps.getValue();
    const body = document.querySelector('body');
    chrome.getBodyClasses$().pipe((0, _rxjs.startWith)([]), (0, _rxjs.pairwise)()).subscribe(([previousClasses, newClasses]) => {
      body.classList.remove(...previousClasses);
      body.classList.add(...newClasses);
    });
    const layout = layoutType === 'grid' ? new _grid.GridLayout(renderCoreDeps, {
      debug: debugLayout,
      projectSideNavVersion
    }) : new _legacyFixed.LegacyFixedLayout(renderCoreDeps, {
      projectSideNavVersion
    });
    const Layout = layout.getComponent();
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRoot.KibanaRootContextProvider, (0, _extends2.default)({}, startServices, {
      globalStyles: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(Layout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    })), targetDomElement);
  }
  /**
   * @public
   */
  addContext(element) {
    const {
      ContextWrapper
    } = this;
    return /*#__PURE__*/_react.default.createElement(ContextWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 12
      }
    }, element);
  }
}
exports.RenderingService = RenderingService;