"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = ColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _palette_colors = require("./palette_colors");
var _rgb_picker = require("./rgb_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/color_picker/color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ColorPicker({
  color,
  palette,
  palettes,
  close,
  selectColor,
  deleteStep
}) {
  const [tab, setTab] = (0, _react.useState)(color.type === 'categorical' && (color.paletteId === palette.id || color.paletteId === _palettes.KbnPalette.Neutral) ? 'palette' : 'custom');
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: 168,
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "none",
    css: {
      borderBottom: 'none'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    expand: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "lns-colorMapping-colorPicker-tab-colors",
    onClick: () => setTab('palette'),
    isSelected: tab === 'palette',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.paletteTabLabel', {
    defaultMessage: 'Colors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "lns-colorMapping-colorPicker-tab-custom",
    onClick: () => setTab('custom'),
    isSelected: tab === 'custom',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.customTabLabel', {
    defaultMessage: 'Custom'
  })))), tab === 'palette' ? /*#__PURE__*/_react.default.createElement(_palette_colors.PaletteColors, {
    color: color,
    palette: palette,
    palettes: palettes,
    selectColor: selectColor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_rgb_picker.RGBPicker, {
    color: color,
    selectColor: selectColor,
    palettes: palettes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), deleteStep ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "xs",
    iconType: "trash",
    onClick: () => {
      close();
      deleteStep();
    },
    css: ({
      euiTheme
    }) => ({
      paddingBottom: euiTheme.size.s
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.removeGradientColorButtonLabel', {
    defaultMessage: 'Remove color stop'
  }))) : null);
}