"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FindingsMisconfigurationFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _overview_tab = require("../overview_tab");
var _json_tab = require("../json_tab");
var _table_tab = require("../table_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/findings_flyout/findings_right/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tabs = [{
  id: 'overview',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTabTitle', {
    defaultMessage: 'Overview'
  })
}, {
  id: 'table',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.tableTabTitle', {
    defaultMessage: 'Table'
  })
}, {
  id: 'json',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.jsonTabTitle', {
    defaultMessage: 'JSON'
  })
}];
const FindingsTab = ({
  tab,
  finding
}) => {
  var _finding$rule, _finding$rule$benchma, _finding$rule2, _finding$rule2$benchm, _finding$rule3;
  const {
    application
  } = (0, _public.useKibana)().services;
  const ruleFlyoutLink =
  // currently we only support rule linking for native CSP findings
  finding.data_stream.dataset === _cloudSecurityPostureCommon.CSP_MISCONFIGURATIONS_DATASET && (_finding$rule = finding.rule) !== null && _finding$rule !== void 0 && (_finding$rule$benchma = _finding$rule.benchmark) !== null && _finding$rule$benchma !== void 0 && _finding$rule$benchma.version && (_finding$rule2 = finding.rule) !== null && _finding$rule2 !== void 0 && (_finding$rule2$benchm = _finding$rule2.benchmark) !== null && _finding$rule2$benchm !== void 0 && _finding$rule2$benchm.id && (_finding$rule3 = finding.rule) !== null && _finding$rule3 !== void 0 && _finding$rule3.id ? application.getUrlForApp('security', {
    path: (0, _reactRouterDom.generatePath)(_cloudSecurityPosture.benchmarksNavigation.rules.path, {
      benchmarkVersion: finding.rule.benchmark.version.split('v')[1],
      // removing the v from the version
      benchmarkId: finding.rule.benchmark.id,
      ruleId: finding.rule.id
    })
  }) : undefined;
  switch (tab.id) {
    case 'overview':
      return /*#__PURE__*/_react.default.createElement(_overview_tab.OverviewTab, {
        data: finding,
        ruleFlyoutLink: ruleFlyoutLink,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 14
        }
      });
    case 'table':
      return /*#__PURE__*/_react.default.createElement(_table_tab.TableTab, {
        data: finding,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 14
        }
      });
    case 'json':
      return /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, {
        data: finding,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 14
        }
      });
    default:
      (0, _std.assertNever)(tab);
  }
};
const FindingsMisconfigurationFlyoutContent = ({
  finding
}) => {
  const [tab, setTab] = (0, _react.useState)(tabs[0]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    direction: 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    expand: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, tabs.map(v => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: v.id,
    isSelected: tab.id === v.id,
    onClick: () => setTab(v),
    "data-test-subj": `findings_flyout_tab_${v.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, v.title))), finding && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    css: (0, _react2.css)`
              position: relative;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    key: tab.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FindingsTab, {
    tab: tab,
    finding: finding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.FindingsMisconfigurationFlyoutContent = FindingsMisconfigurationFlyoutContent;
var _default = exports.default = FindingsMisconfigurationFlyoutContent;