"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionCopyLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var i18n = _interopRequireWildcard(require("./translations"));
var _navigation = require("../../common/navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/copy_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UserActionCopyLinkComponent = ({
  id: commentId
}) => {
  const {
    getCaseViewUrl
  } = (0, _navigation.useCaseViewNavigation)();
  const {
    detailName
  } = (0, _navigation.useCaseViewParams)();
  const handleAnchorLink = (0, _react.useCallback)(() => {
    (0, _copyToClipboard.default)(getCaseViewUrl({
      detailName,
      commentId
    }, true));
  }, [detailName, commentId, getCaseViewUrl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 41
      }
    }, i18n.COPY_REFERENCE_LINK),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.COPY_REFERENCE_LINK,
    "data-test-subj": `copy-link-${commentId}`,
    onClick: handleAnchorLink,
    iconType: "link",
    id: `${commentId}-permLink`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }));
};
UserActionCopyLinkComponent.displayName = 'UserActionCopyLink';
const UserActionCopyLink = exports.UserActionCopyLink = /*#__PURE__*/(0, _react.memo)(UserActionCopyLinkComponent);