"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentCasesComp = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _localized_date_tooltip = require("../localized_date_tooltip");
var _icon_with_count = require("./icon_with_count");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../links");
var _loading_placeholders = require("./loading_placeholders");
var _no_cases = require("./no_cases");
var _truncated_text = require("../truncated_text");
var _markdown_editor = require("../markdown_editor");
var _use_get_cases = require("../../containers/use_get_cases");
var _use_available_owners = require("../app/use_available_owners");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/recent_cases/recent_cases.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getMarkdownContainerCss = euiTheme => (0, _react2.css)`
  max-height: 150px;
  overflow-y: auto;
  color: ${euiTheme.colors.textSubdued};
`;
const getTruncateCompCss = (0, _react2.css)`
  & .euiMarkdownFormat {
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
    word-break: break-word;
  }
`;
const RecentCasesComp = exports.RecentCasesComp = /*#__PURE__*/_react.default.memo(({
  filterOptions,
  maxCasesToShow,
  recentCasesFilterBy
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const availableSolutions = (0, _use_available_owners.useAvailableCasesOwners)(['read']);
  const hasOwner = !!owner.length;
  const {
    data = _use_get_cases.initialData,
    isLoading: isLoadingCases
  } = (0, _use_get_cases.useGetCases)({
    queryParams: {
      perPage: maxCasesToShow
    },
    filterOptions: {
      ...filterOptions,
      owner: hasOwner ? owner : availableSolutions
    }
  });
  return isLoadingCases ? /*#__PURE__*/_react.default.createElement(_loading_placeholders.LoadingPlaceholders, {
    lines: 2,
    placeholders: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }) : !isLoadingCases && data.cases.length === 0 ? /*#__PURE__*/_react.default.createElement(_no_cases.NoCases, {
    recentCasesFilterBy: recentCasesFilterBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.cases.map((c, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: c.id,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: c.id,
    title: c.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
    text: c.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }), c.description && c.description.length && /*#__PURE__*/_react.default.createElement("div", {
    css: getMarkdownContainerCss(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: getTruncateCompCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, {
    disableLinks: true,
    textSize: "relative",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 21
    }
  }, c.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "default",
    "data-test-subj": "recent-cases-creation-relative-time",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_localized_date_tooltip.LocalizedDateTooltip, {
    date: new Date(c.createdAt),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: c.createdAt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_icon_with_count.IconWithCount, {
    count: c.totalComment,
    icon: 'editorComment',
    tooltip: i18n.COMMENTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 17
    }
  })), i !== data.cases.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 47
    }
  })))));
});
RecentCasesComp.displayName = 'RecentCasesComp';