"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDownloadButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _files = require("../../../common/files");
var _use_cases_context = require("../cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/files/file_download_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FileDownloadButtonComponent = ({
  fileId,
  isIcon
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    client: filesClient
  } = (0, _sharedUxFileContext.useFilesContext)();
  const buttonProps = {
    iconType: 'download',
    'aria-label': i18n.DOWNLOAD_FILE,
    href: filesClient.getDownloadHref({
      fileKind: (0, _files.constructFileKindIdByOwner)(owner[0]),
      id: fileId
    }),
    'data-test-subj': 'cases-files-download-button'
  };
  return isIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({}, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }), i18n.DOWNLOAD_FILE);
};
FileDownloadButtonComponent.displayName = 'FileDownloadButton';
const FileDownloadButton = exports.FileDownloadButton = /*#__PURE__*/_react.default.memo(FileDownloadButtonComponent);