"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyboardShortcutsDoc = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _keymap = require("../../lib/keymap");
var _get_client_platform = require("../../lib/get_client_platform");
var _get_id = require("../../lib/get_id");
var _get_pretty_shortcut = require("../../lib/get_pretty_shortcut");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/keyboard_shortcuts_doc/keyboard_shortcuts_doc.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getFlyoutCloseButtonAriaLabel: () => _i18n.i18n.translate('xpack.canvas.keyboardShortcutsDoc.flyout.closeButtonAriaLabel', {
    defaultMessage: 'Closes keyboard shortcuts reference'
  }),
  getShortcutSeparator: () => _i18n.i18n.translate('xpack.canvas.keyboardShortcutsDoc.shortcutListSeparator', {
    defaultMessage: 'or',
    description: 'Separates which keyboard shortcuts can be used for a single action. Example: "{shortcut1} or {shortcut2} or {shortcut3}"'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.keyboardShortcutsDoc.flyoutHeaderTitle', {
    defaultMessage: 'Keyboard shortcuts'
  })
};
const os = (0, _get_client_platform.getClientPlatform)();
const getDescriptionListItems = shortcuts => shortcuts.map(shortcutKeyMap => {
  const osShortcuts = shortcutKeyMap[os];
  return {
    title: shortcutKeyMap.help,
    description: osShortcuts.reduce((acc, shortcut, i) => {
      // replace +'s with spaces so we can display the plus symbol for the plus key
      shortcut = shortcut.replace(/\+/g, ' ');
      if (i !== 0) {
        acc.push(/*#__PURE__*/_react.default.createElement("span", {
          key: (0, _get_id.getId)('span'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 20
          }
        }, " ", strings.getShortcutSeparator(), " "));
      }
      acc.push(/*#__PURE__*/_react.default.createElement("span", {
        key: (0, _get_id.getId)('span'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }, (0, _get_pretty_shortcut.getPrettyShortcut)(shortcut).split(/( )/g).map(key => key === ' ' ? key : /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        key: (0, _get_id.getId)('shortcut'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 50
        }
      }, key))));
      return acc;
    }, [])
  };
});
const KeyboardShortcutsDoc = ({
  onClose
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
  closeButtonProps: {
    'aria-label': strings.getFlyoutCloseButtonAriaLabel()
  },
  size: "s",
  onClose: onClose,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("h2", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 9
  }
}, strings.getTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 5
  }
}, Object.values(_keymap.keymap).map(namespace => {
  const {
    displayName,
    ...shortcuts
  } = namespace;
  return /*#__PURE__*/_react.default.createElement("div", {
    key: (0, _get_id.getId)('shortcuts'),
    className: "canvasKeyboardShortcut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, displayName)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    type: "column",
    listItems: getDescriptionListItems(Object.values(shortcuts)),
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }));
})));
exports.KeyboardShortcutsDoc = KeyboardShortcutsDoc;
KeyboardShortcutsDoc.propTypes = {
  onClose: _propTypes.default.func.isRequired
};