"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorManager = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _i18n = require("@kbn/i18n");
var _color_dot = require("../color_dot/color_dot");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/color_manager/color_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getAddAriaLabel: () => _i18n.i18n.translate('xpack.canvas.colorManager.addAriaLabel', {
    defaultMessage: 'Add Color'
  }),
  getCodePlaceholder: () => _i18n.i18n.translate('xpack.canvas.colorManager.codePlaceholder', {
    defaultMessage: 'Color code'
  }),
  getRemoveAriaLabel: () => _i18n.i18n.translate('xpack.canvas.colorManager.removeAriaLabel', {
    defaultMessage: 'Remove Color'
  })
};
const ColorManager = ({
  hasButtons = false,
  onAddColor,
  onChange,
  onRemoveColor,
  value = ''
}) => {
  const validColor = _chromaJs.default.valid(value);
  let buttons = null;
  if (hasButtons) {
    buttons = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": strings.getAddAriaLabel(),
      iconType: "plusInCircle",
      isDisabled: !validColor || !onAddColor,
      onClick: () => onAddColor && onAddColor(value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": strings.getRemoveAriaLabel(),
      iconType: "minusInCircle",
      isDisabled: !validColor || !onRemoveColor,
      onClick: () => onRemoveColor && onRemoveColor(value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_color_dot.ColorDot, {
    value: validColor ? value : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'inline-block'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: value,
    isInvalid: !validColor && value.length > 0,
    placeholder: strings.getCodePlaceholder(),
    onChange: e => onChange(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })), buttons);
};
exports.ColorManager = ColorManager;
ColorManager.propTypes = {
  hasButtons: _propTypes.default.bool,
  onAddColor: _propTypes.default.func,
  onChange: _propTypes.default.func.isRequired,
  onRemoveColor: _propTypes.default.func,
  value: _propTypes.default.string
};