"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticDocsLink = ElasticDocsLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/elastic_docs_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// union type constisting of valid guide sections that we link to

function ElasticDocsLink({
  section,
  path,
  children,
  ...rest
}) {
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const baseUrl = docLinks.ELASTIC_WEBSITE_URL;
  const version = section === '/cloud' ? 'current' : docLinks.DOC_LINK_VERSION;
  const href = `${baseUrl}guide/en${section}/${version}${path}`;
  return typeof children === 'function' ?
  // @ts-expect-error @types/react@18 This expression is not callable.
  children(href) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmElasticDocsLinkLink",
    href: href
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }), children);
}