"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessMetricsDetails = ServerlessMetricsDetails;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _serverless_metrics = require("../../metrics/serverless_metrics");
var _serverless = require("../../../../../common/serverless");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics_details/serverless_metrics_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServerlessMetricsDetails({
  serverlessId
}) {
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    path,
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics/{id}');
  const serverlessFunctionName = (0, _react.useMemo)(() => (0, _serverless.getServerlessFunctionNameFromId)(serverlessId), [serverlessId]);
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title: serverlessFunctionName,
    href: apmRouter.link('/services/{serviceName}/metrics/{id}', {
      path,
      query
    })
  }), [apmRouter, path, query, serverlessFunctionName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, serverlessFunctionName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_serverless_metrics.ServerlessMetrics, {
    serverlessId: serverlessId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })));
}