"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsDetails = MetricsDetails;
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../common/agent_name");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _serverless_metrics_details = require("./serverless_metrics_details");
var _service_node_metrics = require("./service_node_metrics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MetricsDetails() {
  const {
    path: {
      id
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics/{id}');
  const {
    serverlessType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  if ((0, _agent_name.isAWSLambdaAgentName)(serverlessType)) {
    return /*#__PURE__*/_react.default.createElement(_serverless_metrics_details.ServerlessMetricsDetails, {
      serverlessId: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_service_node_metrics.ServiceNodeMetrics, {
    serviceNodeName: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 10
    }
  });
}