"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmRuleKqlFilter = ApmRuleKqlFilter;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _apm_rule_unified_search_bar = require("./apm_rule_unified_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/apm_rule_kql_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmRuleKqlFilter({
  ruleParams,
  setRuleParams,
  onToggleKqlFilter
}) {
  var _ruleParams$useKqlFil;
  const kqlFilterToggle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.apm.rules.transactionDuration.kqlFilterToggle', {
      defaultMessage: 'Use KQL Filter'
    }),
    checked: (_ruleParams$useKqlFil = ruleParams.useKqlFilter) !== null && _ruleParams$useKqlFil !== void 0 ? _ruleParams$useKqlFil : false,
    onChange: onToggleKqlFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }));
  const kqlFilter = ruleParams.useKqlFilter ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.rules.ruleFlyout.filterLabel', {
      defaultMessage: 'Filter'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.rules.ruleFlyout.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_rule_unified_search_bar.ApmRuleUnifiedSearchBar, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, kqlFilterToggle, kqlFilter);
}