"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddLogRateAnalysisEmbeddableAction = createAddLogRateAnalysisEmbeddableAction;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _presentationUtil = require("@kbn/presentation-util");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("@kbn/aiops-log-rate-analysis/constants");
var _constants2 = require("@kbn/aiops-common/constants");
var _uuid = require("uuid");
var _log_rate_analysis_config_input = require("../embeddables/log_rate_analysis/log_rate_analysis_config_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/aiops/public/ui_actions/create_log_rate_analysis_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddLogRateAnalysisEmbeddableAction(coreStart, pluginStart) {
  return {
    id: 'create-log-rate-analysis-embeddable',
    grouping: _constants2.AIOPS_EMBEDDABLE_GROUPING,
    getIconType: () => 'logRateAnalysis',
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysisDisplayName', {
      defaultMessage: 'Log rate analysis'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      const uuid = (0, _uuid.v4)();
      (0, _presentationUtil.openLazyFlyout)({
        core: coreStart,
        parentApi: context.embeddable,
        flyoutProps: {
          hideCloseButton: true,
          focusedPanelId: uuid,
          'data-test-subj': 'aiopsLogRateAnalysisEmbeddableInitializer',
          'aria-labelledby': 'logRateAnalysisConfig'
        },
        loadContent: async ({
          closeFlyout
        }) => {
          const initialState = {
            dataViewId: undefined
          };
          const embeddable = await presentationContainerParent.addNewPanel({
            panelType: _constants.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE,
            serializedState: {
              rawState: initialState
            },
            maybePanelId: uuid
          });
          if (!embeddable) {
            return;
          }
          return /*#__PURE__*/_react.default.createElement(_log_rate_analysis_config_input.EmbeddableLogRateAnalysisUserInput, {
            isNewPanel: true,
            pluginStart: pluginStart,
            logRateAnalysisControlsApi: embeddable,
            onConfirm: updatedState => {
              embeddable.updateUserInput(updatedState);
              closeFlyout();
            },
            onCancel: () => {
              presentationContainerParent.removePanel(embeddable.uuid);
              closeFlyout();
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 86,
              columnNumber: 13
            }
          });
        }
      });
    }
  };
}