"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MINIMUM_WIDTH_FOR_GRID_CONTROLS = exports.EuiDataGridToolbar = void 0;
exports.checkOrDefaultToolBarDisplayOptions = checkOrDefaultToolBarDisplayOptions;
exports.getNestedObjectOptions = getNestedObjectOptions;
exports.renderAdditionalControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../../../utils");
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _data_grid_toolbar = require("./data_grid_toolbar.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // When below this number the grid only shows the right control icon buttons
var MINIMUM_WIDTH_FOR_GRID_CONTROLS = exports.MINIMUM_WIDTH_FOR_GRID_CONTROLS = 479;
var EuiDataGridToolbar = exports.EuiDataGridToolbar = function EuiDataGridToolbar(_ref) {
  var gridWidth = _ref.gridWidth,
    _ref$minSizeForContro = _ref.minSizeForControls,
    minSizeForControls = _ref$minSizeForContro === void 0 ? MINIMUM_WIDTH_FOR_GRID_CONTROLS : _ref$minSizeForContro,
    toolbarVisibility = _ref.toolbarVisibility,
    isFullScreen = _ref.isFullScreen,
    fullScreenSelector = _ref.fullScreenSelector,
    keyboardShortcuts = _ref.keyboardShortcuts,
    displaySelector = _ref.displaySelector,
    columnSelector = _ref.columnSelector,
    columnSorting = _ref.columnSorting,
    renderCustomToolbar = _ref.renderCustomToolbar;
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_toolbar.euiDataGridToolbarStyles);

  // Enables/disables grid controls based on available width
  var hasRoomForGridControls = _utils.IS_JEST_ENVIRONMENT ? true : gridWidth > minSizeForControls || isFullScreen;
  var columnControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showColumnSelector') ? columnSelector : null;
  var columnSortingControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showSortSelector') ? columnSorting : null;
  var keyboardShortcutsControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showKeyboardShortcuts') ? keyboardShortcuts : (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, {
    showOnFocus: true
  }, (0, _react2.jsx)("span", null, keyboardShortcuts));
  var displayControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showDisplaySelector') ? displaySelector : null;
  var fullScreenControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showFullScreenSelector') ? fullScreenSelector : null;
  if (renderCustomToolbar) {
    return renderCustomToolbar({
      hasRoomForGridControls: hasRoomForGridControls,
      columnControl: columnControl,
      columnSortingControl: columnSortingControl,
      keyboardShortcutsControl: keyboardShortcutsControl,
      displayControl: displayControl,
      fullScreenControl: fullScreenControl
    });
  }
  return (0, _react2.jsx)("div", {
    css: styles.euiDataGrid__controls,
    className: "euiDataGrid__controls",
    "data-test-subj": "dataGridControls"
  }, hasRoomForGridControls && (0, _react2.jsx)("div", {
    css: styles.euiDataGrid__leftControls,
    className: "euiDataGrid__leftControls"
  }, renderAdditionalControls(toolbarVisibility, 'left.prepend'), columnControl, columnSortingControl, renderAdditionalControls(toolbarVisibility, 'left.append')), (0, _react2.jsx)("div", {
    css: styles.euiDataGrid__rightControls,
    className: "euiDataGrid__rightControls"
  }, renderAdditionalControls(toolbarVisibility, 'right'), keyboardShortcutsControl, displayControl, fullScreenControl));
};

/**
 * Toolbar utilities
 */

// Typeguards to see if toolbarVisibility has a certain boolean property assigned
// If not, just set it to true and assume it's OK to show
function objectHasKey(object, key) {
  return object.hasOwnProperty(key);
}
function checkOrDefaultToolBarDisplayOptions(arg, option) {
  if (arg === undefined) {
    return true;
  } else if (typeof arg === 'boolean') {
    return arg;
  } else if (objectHasKey(arg, option)) {
    return arg[option];
  } else {
    return true;
  }
}
var renderAdditionalControls = exports.renderAdditionalControls = function renderAdditionalControls(toolbarVisibility, position) {
  if (typeof toolbarVisibility === 'boolean') return null;
  var _ref2 = toolbarVisibility || {},
    additionalControls = _ref2.additionalControls;
  if (!additionalControls) return null;

  // API backwards compatability: if the consumer passed a single ReactNode
  // to `additionalControls`, default to the left append position.
  if ( /*#__PURE__*/(0, _react.isValidElement)(additionalControls) && position === 'left.append') {
    return additionalControls;
  }
  if (_typeof(additionalControls) !== 'object') {
    return null;
  }
  var handleLeftObjectConfig = function handleLeftObjectConfig(leftConfig) {
    if (position === 'left.prepend') {
      return leftConfig.prepend;
    }
    if (position === 'left.append') {
      return leftConfig.append;
    }
  };
  var handleObjectConfig = function handleObjectConfig(additionalControls) {
    if (position === 'right') {
      return additionalControls.right;
    }
    // API backwards compatability: If the consumer passed a single ReactNode
    // to `additionalControls.left`, default to the left append position
    if ( /*#__PURE__*/(0, _react.isValidElement)(additionalControls.left) && position === 'left.append') {
      return additionalControls.left;
    }
    if (additionalControls.left && _typeof(additionalControls.left) === 'object') {
      return handleLeftObjectConfig(additionalControls.left);
    }
  };
  var rendered = handleObjectConfig(additionalControls);
  return rendered || null;
};

/**
 * Utility helper for selectors/controls that allow nested options
 * (e.g. column selector, display selector)
 */

function getNestedObjectOptions(controlOption, objectKey) {
  var _controlOption$object;
  // If the config is a boolean, nested options follow that boolean
  if (typeof controlOption === 'boolean') return controlOption;
  // If config is not defined, default to enabled
  if (controlOption == null) return true;
  // Otherwise, type should be an object of boolean values - dive into it and return the value
  return !!((_controlOption$object = controlOption[objectKey]) !== null && _controlOption$object !== void 0 ? _controlOption$object : true);
}