"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = CreateSourceEditor;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _kibana_services = require("../../../kibana_services");
var _esql_editor = require("./esql_editor");
var _narrow_by_field = require("./narrow_by_field");
var _esql_utils = require("./esql_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/esql_source/create_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateSourceEditor(props) {
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [adhocDataViewId, setAdhocDataViewId] = (0, _react.useState)();
  const [columns, setColumns] = (0, _react.useState)([]);
  const [esql, setEsql] = (0, _react.useState)('');
  const [dateField, setDateField] = (0, _react.useState)();
  const [dateFields, setDateFields] = (0, _react.useState)([]);
  const [geoField, setGeoField] = (0, _react.useState)();
  const [geoFields, setGeoFields] = (0, _react.useState)([]);
  const [narrowByGlobalSearch, setNarrowByGlobalSearch] = (0, _react.useState)(true);
  const [narrowByGlobalTime, setNarrowByGlobalTime] = (0, _react.useState)(true);
  const [narrowByMapBounds, setNarrowByMapBounds] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    let ignore = false;
    function getDataView() {
      return props.mostCommonDataViewId ? (0, _kibana_services.getIndexPatternService)().get(props.mostCommonDataViewId) : (0, _kibana_services.getIndexPatternService)().getDefaultDataView();
    }
    getDataView().then(async dataView => {
      const adhocDataView = dataView ? await (0, _esqlUtils.getESQLAdHocDataview)(`from ${dataView.getIndexPattern()}`, (0, _kibana_services.getIndexPatternService)()) : undefined;
      if (ignore) {
        return;
      }
      if (adhocDataView) {
        let initialGeoField;
        const initialDateFields = [];
        const initialGeoFields = [];
        for (let i = 0; i < adhocDataView.fields.length; i++) {
          const field = adhocDataView.fields[i];
          if ([_constants.ES_GEO_FIELD_TYPE.GEO_POINT, _constants.ES_GEO_FIELD_TYPE.GEO_SHAPE].includes(field.type)) {
            initialGeoFields.push(field.name);
            if (!initialGeoField) initialGeoField = field;
          } else if ('date' === field.type) {
            initialDateFields.push(field.name);
          }
        }
        if (initialGeoField) {
          let initialDateField;
          // get default time field from default data view instead of adhoc data view
          if (dataView !== null && dataView !== void 0 && dataView.timeFieldName) {
            initialDateField = dataView.timeFieldName;
          } else if (initialDateFields.length) {
            initialDateField = initialDateFields[0];
          }
          const initialEsql = `from ${adhocDataView.getIndexPattern()} | keep ${initialGeoField.name} | limit 10000`;
          setColumns([{
            name: initialGeoField.name,
            type: initialGeoField.type === _constants.ES_GEO_FIELD_TYPE.GEO_SHAPE ? _esql_utils.ESQL_GEO_SHAPE_TYPE : _esql_utils.ESQL_GEO_POINT_TYPE
          }]);
          setAdhocDataViewId(adhocDataView.id);
          setDateField(initialDateField);
          setDateFields(initialDateFields);
          setGeoField(initialGeoField.name);
          setGeoFields(initialGeoFields);
          setEsql(initialEsql);
          if (!initialDateField) {
            setNarrowByGlobalTime(false);
          }
        }
      }
      setIsInitialized(true);
    }).catch(err => {
      if (ignore) {
        return;
      }
      setIsInitialized(true);
    });
    return () => {
      ignore = true;
    };
    // only run on mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _useDebounce.default)(() => {
    const sourceConfig = esql && esql.length && adhocDataViewId ? {
      columns,
      dataViewId: adhocDataViewId,
      dateField,
      geoField,
      esql,
      narrowByGlobalSearch,
      narrowByGlobalTime,
      narrowByMapBounds
    } : null;
    props.onSourceConfigChange(sourceConfig);
  }, 0, [adhocDataViewId, columns, dateField, geoField, esql, narrowByGlobalSearch, narrowByGlobalTime, narrowByMapBounds]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    isLoading: !isInitialized,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_esql_editor.ESQLEditor, {
    esql: esql,
    onESQLChange: change => {
      setAdhocDataViewId(change.adhocDataViewId);
      setColumns(change.columns);
      setEsql(change.esql);
      setDateFields(change.dateFields);
      setGeoFields(change.geoFields);
      if (!dateField || !change.dateFields.includes(dateField)) {
        if (change.dateFields.length) {
          setDateField(change.dateFields[0]);
        } else {
          setDateField(undefined);
          setNarrowByGlobalTime(false);
        }
      }
      if (!geoField || !change.geoFields.includes(geoField)) {
        if (change.geoFields.length) {
          setGeoField(change.geoFields[0]);
        } else {
          setGeoField(undefined);
          setNarrowByMapBounds(false);
        }
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), esql && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_narrow_by_field.NarrowByMapBounds, {
    esql: esql,
    field: geoField,
    fields: geoFields,
    narrowByField: narrowByMapBounds,
    onFieldChange: fieldName => {
      setGeoField(fieldName);
    },
    onNarrowByFieldChange: narrowByField => {
      setNarrowByMapBounds(narrowByField);
      // auto select first geo field when enabling narrowByMapBounds and geoField is not set
      if (narrowByField && geoFields.length && !!geoField) {
        setGeoField(geoFields[0]);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.esqlSource.narrowByGlobalSearchLabel', {
      defaultMessage: `Apply global search to ES|QL statement`
    }),
    checked: narrowByGlobalSearch,
    onChange: event => {
      setNarrowByGlobalSearch(event.target.checked);
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_narrow_by_field.NarrowByTime, {
    esql: esql,
    field: dateField,
    fields: dateFields,
    narrowByField: narrowByGlobalTime,
    onFieldChange: fieldName => {
      setDateField(fieldName);
    },
    onNarrowByFieldChange: narrowByField => {
      setNarrowByGlobalTime(narrowByField);
      // auto select first geo field when enabling narrowByMapBounds and geoField is not set
      if (narrowByField && dateFields.length && !!dateField) {
        setDateField(dateFields[0]);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }))));
}