"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.point2PointLayerWizardConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _vector_style_defaults = require("../../styles/vector/vector_style_defaults");
var _vector_layer = require("../../layers/vector_layer");
var _es_pew_pew_source = require("./es_pew_pew_source");
var _vector_style = require("../../styles/vector/vector_style");
var _constants = require("../../../../common/constants");
var _color_palettes = require("../../styles/color_palettes");
var _create_source_editor = require("./create_source_editor");
var _point_2_point_layer_icon = require("../../layers/wizards/icons/point_2_point_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_pew_pew_source/point_2_point_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
const point2PointLayerWizardConfig = exports.point2PointLayerWizardConfig = {
  id: _constants.WIZARD_ID.POINT_2_POINT,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.source.pewPewDescription', {
    defaultMessage: 'Aggregated data paths between the source and destination'
  }),
  icon: _point_2_point_layer_icon.Point2PointLayerIcon,
  renderWizard: ({
    previewLayers
  }) => {
    const onSourceConfigChange = sourceConfig => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const defaultDynamicProperties = (0, _vector_style_defaults.getDefaultDynamicProperties)();
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor: _es_pew_pew_source.ESPewPewSource.createDescriptor(sourceConfig),
        style: _vector_style.VectorStyle.createDescriptor({
          [_constants.VECTOR_STYLES.LINE_COLOR]: {
            type: _constants.STYLE_TYPE.DYNAMIC,
            options: {
              ...defaultDynamicProperties[_constants.VECTOR_STYLES.LINE_COLOR].options,
              field: {
                name: _constants.COUNT_PROP_NAME,
                origin: _constants.FIELD_ORIGIN.SOURCE
              },
              color: _color_palettes.NUMERICAL_COLOR_PALETTES[0].value
            }
          },
          [_constants.VECTOR_STYLES.LINE_WIDTH]: {
            type: _constants.STYLE_TYPE.DYNAMIC,
            options: {
              ...defaultDynamicProperties[_constants.VECTOR_STYLES.LINE_WIDTH].options,
              field: {
                name: _constants.COUNT_PROP_NAME,
                origin: _constants.FIELD_ORIGIN.SOURCE
              }
            }
          }
        })
      });
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      onSourceConfigChange: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 12
      }
    });
  },
  title: _es_pew_pew_source.sourceTitle
};