"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = ConfirmDeleteModal;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/logstash/public/application/components/pipeline_list/confirm_delete_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ConfirmDeleteModal({
  cancelDeletePipelines,
  deleteSelectedPipelines,
  selection,
  showConfirmDeleteModal
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!showConfirmDeleteModal) {
    return null;
  }
  const numPipelinesSelected = selection.length;
  const confirmText = numPipelinesSelected === 1 ? {
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelineWarningMessage",
      defaultMessage: "You cannot recover a deleted pipeline",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 13
      }
    }),
    button: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelineConfirmButtonLabel",
      defaultMessage: "Delete pipeline",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelineTitle",
      defaultMessage: "Delete pipeline \"{id}\"",
      values: {
        id: selection[0].id
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    })
  } : {
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelinesWarningMessage",
      defaultMessage: "You cannot recover deleted pipelines.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }),
    button: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelinesConfirmButtonLabel",
      defaultMessage: "Delete {numPipelinesSelected} pipelines",
      values: {
        numPipelinesSelected
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.deletedPipelinesTitle",
      defaultMessage: "Delete {numPipelinesSelected} pipelines",
      values: {
        numPipelinesSelected
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeleteModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }),
    confirmButtonText: confirmText.button,
    defaultFocusedButton: _eui.EUI_MODAL_CANCEL_BUTTON,
    onCancel: cancelDeletePipelines,
    onConfirm: deleteSelectedPipelines,
    title: confirmText.title,
    titleProps: {
      id: modalTitleId
    },
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, confirmText.message));
}