"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteList = void 0;
var _utils = require("../utils");
var _get_list = require("./get_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteList = async ({
  id,
  esClient,
  listIndex,
  listItemIndex
}) => {
  const list = await (0, _get_list.getList)({
    esClient,
    id,
    listIndex
  });
  if (list == null) {
    return null;
  } else {
    await esClient.deleteByQuery({
      conflicts: 'proceed',
      index: listItemIndex,
      query: {
        term: {
          list_id: id
        }
      },
      refresh: false
    });
    const response = await esClient.deleteByQuery({
      conflicts: 'proceed',
      index: listIndex,
      query: {
        ids: {
          values: [id]
        }
      },
      refresh: false
    });
    if (response.deleted) {
      const checkIfListDeleted = async () => {
        const deletedList = await (0, _get_list.getList)({
          esClient,
          id,
          listIndex
        });
        if (deletedList !== null) {
          throw Error('List has not been re-indexed in time');
        }
      };
      await (0, _utils.waitUntilDocumentIndexed)(checkIfListDeleted);
    } else {
      throw Error('No list has been deleted');
    }
    return list;
  }
};
exports.deleteList = deleteList;