"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSaveToLibrary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _common = require("../../common");
var _duplicate_title_check = require("./duplicate_title_check");
var _links_content_management_client = require("./links_content_management_client");
var _resolve_links = require("../lib/resolve_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/links/public/content_management/save_to_library.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const modalTitle = _i18n.i18n.translate('links.contentManagement.saveModalTitle', {
  defaultMessage: `Save {contentId} panel to library`,
  values: {
    contentId: _common.LINKS_EMBEDDABLE_TYPE
  }
});
const runSaveToLibrary = async newState => {
  return new Promise((resolve, reject) => {
    var _newState$title2;
    const onSave = async ({
      newTitle,
      newDescription,
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    }) => {
      var _newState$title, _newState$links;
      if (!(await (0, _duplicate_title_check.checkForDuplicateTitle)({
        title: newTitle,
        lastSavedTitle: (_newState$title = newState.title) !== null && _newState$title !== void 0 ? _newState$title : '',
        copyOnSave: false,
        onTitleDuplicate,
        isTitleDuplicateConfirmed
      }))) {
        return {};
      }
      const newAttributes = {
        ...newState,
        links: (0, _resolve_links.serializeResolvedLinks)((_newState$links = newState.links) !== null && _newState$links !== void 0 ? _newState$links : []),
        title: newTitle,
        description: newDescription
      };
      try {
        const {
          item: {
            id
          }
        } = await _links_content_management_client.linksClient.create({
          data: newAttributes
        });
        resolve({
          ...newState,
          title: newTitle,
          description: newDescription,
          savedObjectId: id
        });
        return {
          id
        };
      } catch (error) {
        reject(error);
        return {
          error
        };
      }
    };
    const saveModal = /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalWithSaveResult, {
      onSave: onSave,
      onClose: () => resolve(undefined),
      title: (_newState$title2 = newState.title) !== null && _newState$title2 !== void 0 ? _newState$title2 : '',
      customModalTitle: modalTitle,
      description: newState.description,
      showDescription: true,
      showCopyOnSave: false,
      objectType: _common.CONTENT_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    });
    (0, _public.showSaveModal)(saveModal);
  });
};
exports.runSaveToLibrary = runSaveToLibrary;