"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformOut = transformOut;
var _bwc = require("./bwc");
var _constants = require("../../constants");
var _references = require("./references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformOut(storedState, references) {
  const state = (0, _bwc.isLegacyState)(storedState) ? (0, _bwc.transformLegacyState)(storedState) : storedState;

  // inject saved object reference when by-reference
  const savedObjectRef = (references !== null && references !== void 0 ? references : []).find(({
    name,
    type
  }) => name === 'savedObjectRef' && type === _constants.LINKS_SAVED_OBJECT_TYPE);
  if (savedObjectRef) {
    return {
      ...state,
      savedObjectId: savedObjectRef.id
    };
  }

  // inject dashboard references when by-value
  return {
    ...state,
    links: (0, _references.injectReferences)(state.links, references)
  };
}