"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractReferences = extractReferences;
exports.injectReferences = injectReferences;
var _lodash = require("lodash");
var _content_management = require("../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function extractReferences(links) {
  const extractedReferences = [];
  const newLinks = links.map(link => {
    if (link.type === _content_management.DASHBOARD_LINK_TYPE && link.destination) {
      const refName = `link_${link.id}_dashboard`;
      extractedReferences.push({
        name: refName,
        type: 'dashboard',
        id: link.destination
      });
      return {
        ...(0, _lodash.omit)(link, 'destination'),
        destinationRefName: refName
      };
    }
    return link;
  });
  return {
    links: newLinks,
    references: extractedReferences
  };
}
function injectReferences(links, references = []) {
  return (links !== null && links !== void 0 ? links : []).map(link => {
    var _reference$id;
    const {
      destinationRefName,
      ...rest
    } = link;
    if (link.type !== _content_management.DASHBOARD_LINK_TYPE || !destinationRefName) {
      return link;
    }
    const reference = references.find(({
      name
    }) => name === destinationRefName);
    return {
      ...rest,
      destination: (_reference$id = reference === null || reference === void 0 ? void 0 : reference.id) !== null && _reference$id !== void 0 ? _reference$id : ''
    };
  });
}