"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DensitySettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/datatable/components/density_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const densityValues = Object.values(_unifiedDataTable.DataGridDensity);
const getValidDensity = density => {
  const isValidDensity = densityValues.includes(density);
  return isValidDensity ? density : _unifiedDataTable.DataGridDensity.NORMAL;
};
const densityLabel = _i18n.i18n.translate('xpack.lens.table.densityLabel', {
  defaultMessage: 'Density'
});
const densityOptions = [{
  id: _unifiedDataTable.DataGridDensity.COMPACT,
  label: _i18n.i18n.translate('xpack.lens.table.labelCompact', {
    defaultMessage: 'Compact'
  })
}, {
  id: _unifiedDataTable.DataGridDensity.NORMAL,
  label: _i18n.i18n.translate('xpack.lens.table.labelNormal', {
    defaultMessage: 'Normal'
  })
}, {
  id: _unifiedDataTable.DataGridDensity.EXPANDED,
  label: _i18n.i18n.translate('xpack.lens.table.labelExpanded', {
    defaultMessage: 'Expanded'
  })
}];
const DensitySettings = ({
  dataGridDensity,
  onChange
}) => {
  // Falls back to NORMAL density when an invalid density is provided
  const validDensity = getValidDensity(dataGridDensity);
  const setDensity = (0, _react.useCallback)(density => {
    onChange(getValidDensity(density));
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: densityLabel,
    "aria-label": densityLabel,
    display: "columnCompressed",
    "data-test-subj": "lnsDensitySettings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: densityLabel,
    buttonSize: "compressed",
    isFullWidth: true,
    options: densityOptions,
    onChange: setDensity,
    idSelected: validDensity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
exports.DensitySettings = DensitySettings;