"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldInputs = FieldInputs;
exports.MAX_MULTI_FIELDS_SIZE = void 0;
exports.getInputFieldErrorMessage = getInputFieldErrorMessage;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _visualizationUtils = require("@kbn/visualization-utils");
var _field_select = require("../../../dimension_panel/field_select");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/terms/field_inputs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const generateId = (0, _eui.htmlIdGenerator)();
const MAX_MULTI_FIELDS_SIZE = exports.MAX_MULTI_FIELDS_SIZE = 3;
function removeNewEmptyField(v) {
  return v.value != null;
}
function FieldInputs({
  column,
  onChange,
  indexPattern,
  operationSupportMatrix,
  invalidFields,
  showTimeSeriesDimensions
}) {
  const onChangeWrapped = (0, _react.useCallback)(values => onChange(values.filter(removeNewEmptyField).map(({
    value
  }) => value)), [onChange]);
  const {
    wrappedValues,
    rawValuesLookup
  } = (0, _react.useMemo)(() => {
    var _column$params;
    const rawValues = column ? [column.sourceField, ...(((_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.secondaryFields) || [])] : [];
    return {
      wrappedValues: rawValues.map(value => ({
        id: generateId(),
        value
      })),
      rawValuesLookup: new Set(rawValues)
    };
  }, [column]);
  const {
    inputValue: localValues,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: onChangeWrapped,
    value: wrappedValues
  });
  const onFieldSelectChange = (0, _react.useCallback)((choice, index = 0) => {
    const fields = [...localValues];
    if (indexPattern.getFieldByName(choice.field)) {
      fields[index] = {
        id: generateId(),
        value: choice.field
      };

      // update the layer state
      handleInputChange(fields);
    }
  }, [localValues, indexPattern, handleInputChange]);
  const disableActions = localValues.length === 1 || localValues.filter(({
    isNew
  }) => !isNew).length < 2;
  const localValuesFilled = localValues.filter(({
    isNew
  }) => !isNew);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DragDropBuckets, {
    onDragEnd: updatedValues => {
      handleInputChange(updatedValues);
    },
    droppableId: "TOP_TERMS_DROPPABLE_AREA",
    items: localValues,
    bgColor: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, localValues.map(({
    id,
    value,
    isNew
  }, index, arrayRef) => {
    var _indexPattern$getFiel;
    // need to filter the available fields for multiple terms
    // * a scripted field should be removed
    // * a field of unsupported type should be removed
    // * a field that has been used
    // * a scripted field was used in a singular term, should be marked as invalid for multi-terms
    const filteredOperationByField = [...operationSupportMatrix.operationByField.keys()].filter(key => {
      if (key === value) {
        return true;
      }
      const field = indexPattern.getFieldByName(key);
      if (index === 0) {
        return !rawValuesLookup.has(key) && field && _constants.supportedTypes.has(field.type);
      } else {
        return !rawValuesLookup.has(key) && field && !field.scripted && _constants.supportedTypes.has(field.type);
      }
    }).reduce((memo, key) => {
      const fieldOps = operationSupportMatrix.operationByField.get(key);
      if (fieldOps) {
        memo.set(key, fieldOps);
      }
      return memo;
    }, new Map());
    const shouldShowError = Boolean(value && (((_indexPattern$getFiel = indexPattern.getFieldByName(value)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.scripted) && localValuesFilled.length > 1 || (invalidFields === null || invalidFields === void 0 ? void 0 : invalidFields.includes(value))));
    const itemId = (value !== null && value !== void 0 ? value : 'newField') + id;
    return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DraggableBucketContainer, {
      id: itemId,
      key: itemId,
      idx: index,
      onRemoveClick: () => {
        handleInputChange(arrayRef.filter((_, i) => i !== index));
      },
      removeTitle: _i18n.i18n.translate('xpack.lens.indexPattern.terms.deleteButtonLabel', {
        defaultMessage: 'Delete'
      }),
      isNotRemovable: disableActions && !isNew,
      isNotDraggable: arrayRef.length < 2,
      "data-test-subj": `indexPattern-terms`,
      Container: _visualizationUiComponents.FieldsBucketContainer,
      isInsidePanel: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
      fieldIsInvalid: shouldShowError,
      currentIndexPattern: indexPattern,
      operationByField: filteredOperationByField,
      selectedOperationType: column.operationType,
      selectedField: value,
      autoFocus: isNew,
      onChoose: choice => {
        onFieldSelectChange(choice, index);
      },
      isInvalid: shouldShowError,
      "data-test-subj": localValues.length !== 1 ? `indexPattern-dimension-field-${index}` : undefined,
      showTimeSeriesDimensions: localValues.length < 2 && showTimeSeriesDimensions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }));
  })), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.NewBucketButton, {
    onClick: () => {
      handleInputChange([...localValues, {
        id: generateId(),
        value: undefined,
        isNew: true
      }]);
    },
    "data-test-subj": `indexPattern-terms-add-field`,
    label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.addaFilter', {
      defaultMessage: 'Add field'
    }),
    isDisabled: column.params.orderBy.type === 'rare' || column.params.orderBy.type === 'significant' || localValues.length > MAX_MULTI_FIELDS_SIZE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }));
}
function getInputFieldErrorMessage(isScriptedField, invalidFields) {
  if (isScriptedField) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.terms.scriptedFieldErrorShort', {
      defaultMessage: 'Scripted fields are not supported when using multiple fields'
    });
  }
  if (invalidFields.length) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.terms.invalidFieldsErrorShort', {
      defaultMessage: 'Invalid {invalidFieldsCount, plural, one {field} other {fields}}: {invalidFields}. Check your data view or pick another field.',
      values: {
        invalidFieldsCount: invalidFields.length,
        invalidFields: invalidFields.map(fieldName => `"${fieldName}"`).join(', ')
      }
    });
  }
}