"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVisibility = useVisibility;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useVisibility() {
  var _elementRef$current;
  const elementRef = (0, _react.useRef)(null);

  // When an element is hidden using `display: none` or `hidden` attribute it has no offset parent.
  return [!!((_elementRef$current = elementRef.current) !== null && _elementRef$current !== void 0 && _elementRef$current.offsetParent), elementRef];
}