"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWithQueryParams = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/utils/redirect_with_query_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// This workaround preserves query parameters in the redirect
// https://github.com/ReactTraining/react-router/issues/5818#issuecomment-379212014
const RedirectWithQueryParams = ({
  from,
  to,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: from,
    render: ({
      location
    }) => {
      return location ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, (0, _extends2.default)({}, rest, {
        from: from,
        to: typeof to === 'string' ? {
          ...location,
          pathname: to
        } : {
          ...location,
          ...to
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 11
        }
      })) : null;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
};
exports.RedirectWithQueryParams = RedirectWithQueryParams;