"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerCharts = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _loading = require("../../../../components/loading");
var _no_data = require("../../../../components/empty_states/no_data");
var _chart = require("./chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetricsExplorerCharts = ({
  isLoading,
  data,
  onLoadMore,
  options,
  chartOptions,
  onRefetch,
  onFilter,
  timeRange,
  onTimeChange
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100%",
      width: "100%",
      text: _i18n.i18n.translate('xpack.infra.metricsExplorer.loadingCharts', {
        defaultMessage: 'Loading charts'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    });
  }
  if (!data || (0, _lodash.first)(data.pages).series.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_no_data.NoData, {
      titleText: _i18n.i18n.translate('xpack.infra.metricsExplorer.noDataTitle', {
        defaultMessage: 'There is no data to display.'
      }),
      bodyText: _i18n.i18n.translate('xpack.infra.metricsExplorer.noDataBodyText', {
        defaultMessage: 'Try adjusting your time, filters or group by settings.'
      }),
      refetchText: _i18n.i18n.translate('xpack.infra.metricsExplorer.noDataRefetchText', {
        defaultMessage: 'Check for new data'
      }),
      testString: "metrics-explorer-no-data",
      onRefetch: onRefetch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    });
  }
  const and = _i18n.i18n.translate('xpack.infra.metricsExplorer.andLabel', {
    defaultMessage: '" and "'
  });
  const firstPage = (0, _lodash.first)(data.pages);
  const hasMore = (0, _lodash.last)(data.pages).pageInfo.afterKey;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "s",
    columns: firstPage.series.length === 1 ? 1 : 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, data.pages.map(page => page.series.map(series => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: series.id,
    style: {
      minWidth: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MetricsExplorerChart, {
    key: `chart-${series.id}`,
    onFilter: onFilter,
    options: options,
    chartOptions: chartOptions,
    title: options.groupBy ? series.id : null,
    height: page.series.length > 1 ? 200 : 400,
    series: series,
    timeRange: timeRange,
    onTimeChange: onTimeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }))))), firstPage.series.length > 1 ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center',
      marginBottom: 16
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsExplorer.footerPaginationMessage",
    defaultMessage: "Displaying {length} of {total} charts grouped by \"{groupBy}\".",
    values: {
      length: (0, _lodash.sumBy)(data.pages, 'series.length'),
      total: firstPage.pageInfo.total,
      groupBy: Array.isArray(options.groupBy) ? options.groupBy.join(and) : options.groupBy
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }))), hasMore ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '16px 0'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraMetricsExplorerChartsLoadMoreChartsButton",
    isLoading: isLoading,
    size: "s",
    onClick: onLoadMore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsExplorer.loadMoreChartsButton",
    defaultMessage: "Load More Charts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }))) : null) : null);
};
exports.MetricsExplorerCharts = MetricsExplorerCharts;