"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryExampleMessageTable = exports.LogEntryExampleMessageRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _rison = require("@kbn/rison");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ml-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _log_analysis = require("../../../../../../common/log_analysis");
var _job_parameters = require("../../../../../../common/log_analysis/job_parameters");
var _datetime = require("../../../../../../common/formatters/datetime");
var _log_flyout = require("../../../../../containers/logs/log_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_rate/sections/anomalies/log_entry_example.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VIEW_DETAILS_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewDetailsLabel', {
  defaultMessage: 'View details'
});
const VIEW_IN_DISCOVER_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewInDiscoverLabel', {
  defaultMessage: 'View in Discover'
});
const VIEW_ANOMALY_IN_ML_LABEL = _i18n.i18n.translate('xpack.infra.logs.analysis.logEntryExamplesViewAnomalyInMlLabel', {
  defaultMessage: 'View anomaly in machine learning'
});
const MENU_LABEL = _i18n.i18n.translate('xpack.infra.logAnomalies.logEntryExamplesMenuLabel', {
  defaultMessage: 'View actions for log entry'
});
const LogEntryExampleMessageRow = ({
  id,
  dataset,
  message,
  timestamp,
  tiebreaker,
  timeRange,
  anomaly,
  euiTheme
}) => {
  const {
    services: {
      ml,
      http,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const {
    openFlyout: openLogEntryFlyout
  } = (0, _log_flyout.useLogEntryFlyoutContext)();
  const humanFriendlyDataset = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset);
  const time = (0, _moment.default)(timestamp).toISOString();
  const viewInStreamLinkProps = (0, _public2.useLinkProps)({
    app: 'logs',
    pathname: 'stream',
    search: {
      logPosition: (0, _rison.encode)({
        end: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        position: {
          tiebreaker,
          time
        },
        start: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        streamLive: false
      }),
      flyoutOptions: (0, _rison.encode)({
        surroundingLogsId: id
      }),
      ...(dataset ? {
        logFilter: (0, _rison.encode)({
          expression: `${_job_parameters.partitionField}: ${dataset}`,
          kind: 'kuery'
        })
      } : {})
    }
  });
  const viewAnomalyInMachineLearningLink = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.SINGLE_METRIC_VIEWER,
    pageState: {
      jobIds: [anomaly.jobId],
      timeRange: {
        from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        mode: 'absolute'
      },
      entities: {
        [_job_parameters.partitionField]: dataset,
        ...((0, _log_analysis.isCategoryAnomaly)(anomaly) ? {
          mlcategory: anomaly.categoryId
        } : {})
      }
    }
  });
  const handleMlLinkClick = (0, _react.useCallback)(e => {
    if (!viewAnomalyInMachineLearningLink || !(0, _public2.shouldHandleLinkEvent)(e)) return;
    application.navigateToUrl(viewAnomalyInMachineLearningLink);
  }, [viewAnomalyInMachineLearningLink, application]);
  const menuItems = (0, _react.useMemo)(() => {
    if (!viewInStreamLinkProps.onClick || !viewAnomalyInMachineLearningLink) {
      return undefined;
    }
    return [{
      label: VIEW_DETAILS_LABEL,
      onClick: () => {
        openLogEntryFlyout(id);
        setIsMenuOpen(false);
      }
    }, {
      label: VIEW_IN_DISCOVER_LABEL,
      onClick: viewInStreamLinkProps.onClick,
      href: viewInStreamLinkProps.href
    }, {
      label: VIEW_ANOMALY_IN_ML_LABEL,
      onClick: handleMlLinkClick,
      href: viewAnomalyInMachineLearningLink
    }];
  }, [id, openLogEntryFlyout, viewInStreamLinkProps, viewAnomalyInMachineLearningLink, handleMlLinkClick]);
  const toggleMenu = (0, _react.useCallback)(() => setIsMenuOpen(!isMenuOpen), [isMenuOpen]);
  const closeMenu = (0, _react.useCallback)(() => setIsMenuOpen(false), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "150px",
    css: {
      color: euiTheme.colors.textSubdued
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, (0, _moment.default)(timestamp).format('HH:mm:ss.SSS')), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, message), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "250px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, humanFriendlyDataset), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    width: "48px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "infraLogEntryExampleMessageRowButton",
      "aria-label": MENU_LABEL,
      iconType: "boxesHorizontal",
      size: "s",
      onClick: toggleMenu,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 13
      }
    }),
    isOpen: isMenuOpen,
    closePopover: closeMenu,
    panelPaddingSize: "none",
    anchorPosition: "leftCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems === null || menuItems === void 0 ? void 0 : menuItems.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: `menu-item-${index}`,
      onClick: e => {
        var _item$onClick;
        (_item$onClick = item.onClick) === null || _item$onClick === void 0 ? void 0 : _item$onClick.call(item, e);
        closeMenu();
      },
      href: item.href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 15
      }
    }, item.label)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }))));
};
exports.LogEntryExampleMessageRow = LogEntryExampleMessageRow;
const LogEntryExampleMessageTable = ({
  examples,
  timeRange,
  anomaly
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dateTime = examples.length > 0 ? examples[0].timestamp : Date.now();
  const columns = [{
    id: 'timestamp',
    header: (0, _datetime.localizedDate)(dateTime),
    width: '122px'
  }, {
    id: 'message',
    header: _i18n.i18n.translate('xpack.infra.logEntryExampleMessageHeaders.logColumnHeader.messageLabel', {
      defaultMessage: 'Message'
    })
  }, {
    id: 'dataset',
    header: 'event.dataset',
    width: '250px'
  }, {
    id: 'actions',
    header: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.infra.logEntryExampleMessageHeaders.actionsHeader', {
      defaultMessage: 'Actions'
    }))),
    width: '48px'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    css: {
      backgroundColor: euiTheme.colors.borderBaseFloating,
      '& .euiTableHeaderCell': {
        paddingBottom: 5
      },
      '& .euiTableRowCell': {
        borderColor: euiTheme.colors.borderBaseFloating,
        fontFamily: euiTheme.font.familyCode
      },
      '& .euiTableCellContent': {
        padding: 0,
        height: '24px'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }, columns.map(column => /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    key: column.id,
    width: column.width,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 11
    }
  }, column.header))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }, examples.map((example, exampleIndex) => /*#__PURE__*/_react.default.createElement(LogEntryExampleMessageRow, (0, _extends2.default)({
    key: exampleIndex
  }, example, {
    timeRange: timeRange,
    anomaly: anomaly,
    euiTheme: euiTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 11
    }
  })))));
};
exports.LogEntryExampleMessageTable = LogEntryExampleMessageTable;