"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCategoriesSetupView = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _log_entry_categories = require("../../../../containers/logs/log_analysis/modules/log_entry_categories");
var _initial_configuration_step = require("../initial_configuration_step");
var _process_step = require("../process_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/setup_flyout/log_entry_categories_setup_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogEntryCategoriesSetupView = ({
  onClose
}) => {
  const {
    categoryQualityWarnings,
    cleanUpAndSetUp,
    endTime,
    fetchJobStatus,
    isValidating,
    lastSetupErrorMessages,
    moduleDescriptor,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    setupStatus,
    startTime,
    validatedIndices,
    validationErrors,
    viewResults
  } = (0, _log_entry_categories.useLogEntryCategoriesSetup)();
  (0, _useMount.default)(() => {
    fetchJobStatus();
  });
  const viewResultsAndClose = (0, _react.useCallback)(() => {
    viewResults();
    onClose();
  }, [viewResults, onClose]);
  const steps = (0, _react.useMemo)(() => [(0, _initial_configuration_step.createInitialConfigurationStep)({
    setStartTime,
    setEndTime,
    startTime,
    endTime,
    isValidating,
    validatedIndices,
    setupStatus,
    setValidatedIndices,
    validationErrors,
    previousQualityWarnings: categoryQualityWarnings
  }), (0, _process_step.createProcessStep)({
    cleanUpAndSetUp,
    errorMessages: lastSetupErrorMessages,
    isConfigurationValid: validationErrors.length <= 0 && !isValidating,
    setUp,
    setupStatus,
    viewResults: viewResultsAndClose
  })], [categoryQualityWarnings, cleanUpAndSetUp, endTime, isValidating, lastSetupErrorMessages, setEndTime, setStartTime, setUp, setValidatedIndices, setupStatus, startTime, validatedIndices, validationErrors, viewResultsAndClose]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, moduleDescriptor.moduleName, " ")), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, moduleDescriptor.moduleDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }));
};
exports.LogEntryCategoriesSetupView = LogEntryCategoriesSetupView;