"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSetupDatasetFilter = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_visibility_state = require("../../../../hooks/use_visibility_state");
var _quality_warning_notices = require("../../log_analysis_job_status/quality_warning_notices");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/initial_configuration_step/index_setup_dataset_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexSetupDatasetFilter = ({
  availableDatasets,
  datasetFilter,
  isDisabled,
  onChangeDatasetFilter
}) => {
  const {
    isVisible,
    hide,
    show
  } = (0, _use_visibility_state.useVisibilityState)(false);
  const changeDatasetFilter = (0, _react.useCallback)(options => {
    const selectedDatasets = options.filter(({
      checked
    }) => checked === 'on').map(({
      label
    }) => label);
    onChangeDatasetFilter(selectedDatasets.length === 0 ? {
      type: 'includeAll'
    } : {
      type: 'includeSome',
      datasets: selectedDatasets
    });
  }, [onChangeDatasetFilter]);
  const selectableOptions = (0, _react.useMemo)(() => availableDatasets.map(({
    dataset,
    warnings
  }) => ({
    label: dataset,
    append: warnings.length > 0 ? /*#__PURE__*/_react.default.createElement(DatasetWarningMarker, {
      warnings: warnings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 39
      }
    }) : null,
    checked: datasetFilter.type === 'includeSome' && datasetFilter.datasets.includes(dataset) ? 'on' : undefined
  })), [availableDatasets, datasetFilter]);
  const datasetFilterButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    disabled: isDisabled,
    isSelected: isVisible,
    onClick: show,
    iconType: "arrowDown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.indexDatasetFilterIncludeAllButtonLabel",
    defaultMessage: "{includeType, select, includeAll {All datasets} includeSome {{includedDatasetCount, plural, one {# dataset} other {# datasets}}} other {No dataset available}}",
    values: {
      includeType: datasetFilter.type,
      includedDatasetCount: datasetFilter.type === 'includeSome' ? datasetFilter.datasets.length : 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: datasetFilterButton,
    closePopover: hide,
    isOpen: isVisible,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    onChange: changeDatasetFilter,
    options: selectableOptions,
    searchable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, search), list))));
};
exports.IndexSetupDatasetFilter = IndexSetupDatasetFilter;
const DatasetWarningMarker = ({
  warnings
}) => {
  const warningDescriptions = warnings.flatMap(warning => warning.type === 'categoryQualityWarning' ? warning.reasons.map(reason => /*#__PURE__*/_react.default.createElement(_quality_warning_notices.CategoryQualityWarningReasonDescription, {
    key: reason.type,
    reason: reason,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })) : []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: warningDescriptions,
    type: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 10
    }
  });
};