"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMetricsCallout = AddMetricsCallout;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _constants = require("./constants");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/add_metrics_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultEventParams = {
  view: 'add_metrics_cta'
};
function AddMetricsCallout({
  id,
  onDismiss
}) {
  const {
    services: {
      telemetry,
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const onboardingLocator = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  function handleAddMetricsClick() {
    telemetry.reportAddMetricsCalloutAddMetricsClicked(defaultEventParams);
  }
  function handleTryItClick() {
    telemetry.reportAddMetricsCalloutTryItClicked(defaultEventParams);
  }
  function handleLearnMoreClick() {
    telemetry.reportAddMetricsCalloutLearnMoreClicked(defaultEventParams);
  }
  function handleDismiss() {
    telemetry.reportAddMetricsCalloutDismissed(defaultEventParams);
    onDismiss === null || onDismiss === void 0 ? void 0 : onDismiss();
  }
  return /*#__PURE__*/_react.default.createElement(_public.AddDataPanel, {
    "data-test-subj": "infraAddMetricsCallout",
    content: (0, _constants.addMetricsCalloutDefinitions)(onboardingLocator)[id].content,
    actions: (0, _constants.addMetricsCalloutDefinitions)(onboardingLocator)[id].actions,
    onAddData: handleAddMetricsClick,
    onTryIt: handleTryItClick,
    onLearnMore: handleLearnMoreClick,
    onDismiss: onDismiss && handleDismiss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
}