"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _fields_list = require("./fields_list");
var _create_field = require("./create_field");
var _delete_field_provider = require("./delete_field_provider");
var _listItemStyle = require("../common/listItemStyle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/fields_list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  addMultiFieldButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addMultiFieldTooltipLabel', {
    defaultMessage: 'Add a multi-field to index the same field in different ways.'
  }),
  addPropertyButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addPropertyButtonLabel', {
    defaultMessage: 'Add property'
  }),
  editButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldButtonLabel', {
    defaultMessage: 'Edit'
  }),
  deleteButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.removeFieldButtonLabel', {
    defaultMessage: 'Remove'
  }),
  fieldIsShadowedLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldIsShadowedLabel', {
    defaultMessage: 'Field shadowed by a runtime field with the same name.'
  }),
  fieldListItemLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldsListItemLabel', {
    defaultMessage: 'Field details'
  }),
  fieldListNameLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldListNameLabel', {
    defaultMessage: 'Field name'
  }),
  fieldListTypesLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldListTypeLabel', {
    defaultMessage: 'Data type'
  })
};
function FieldListItemComponent({
  field,
  allFields,
  isHighlighted,
  isDimmed,
  isCreateFieldFormVisible,
  areActionButtonsVisible,
  isLastItem,
  isShadowed = false,
  childFieldsArray,
  maxNestedDepth,
  addField,
  editField,
  toggleExpand,
  treeDepth,
  state,
  isAddingFields,
  setPreviousState,
  pendingFieldsRef
}, ref) {
  const {
    source,
    isMultiField,
    canHaveChildFields,
    hasChildFields,
    canHaveMultiFields,
    hasMultiFields,
    isExpanded,
    path
  } = field;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _listItemStyle.getListItemStyle)(euiTheme);

  // When there aren't any "child" fields (the maxNestedDepth === 0), there is no toggle icon on the left of any field.
  // For that reason, we need to compensate and substract some indent to left align on the page.
  const substractIndentAmount = maxNestedDepth === 0 ? _constants.CHILD_FIELD_INDENT_SIZE * 0.5 : 0;
  const indent = treeDepth * _constants.CHILD_FIELD_INDENT_SIZE - substractIndentAmount;
  const isSemanticText = source.type === 'semantic_text';
  const hasDottedLine = isMultiField ? isLastItem ? false : true : canHaveMultiFields && isExpanded;
  const renderCreateField = () => {
    if (!isCreateFieldFormVisible) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_create_field.CreateField, {
      allFields: allFields,
      isRootLevelField: false,
      isMultiField: canHaveMultiFields,
      isAddingFields: isAddingFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    });
  };
  const renderActionButtons = () => {
    if (!areActionButtonsVisible) {
      return null;
    }
    const {
      addMultiFieldButtonLabel,
      addPropertyButtonLabel,
      editButtonLabel,
      deleteButtonLabel
    } = i18nTexts;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      css: styles.actions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 7
      }
    }, canHaveMultiFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: addMultiFieldButtonLabel,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "documents",
      onClick: addField,
      "data-test-subj": "addMultiFieldButton",
      "aria-label": addMultiFieldButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }))), canHaveChildFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: addPropertyButtonLabel,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      onClick: addField,
      "data-test-subj": "addPropertyButton",
      "aria-label": addPropertyButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: editButtonLabel,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: editField,
      "data-test-subj": "editFieldButton",
      "aria-label": editButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_delete_field_provider.DeleteFieldProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, deleteField => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: deleteButtonLabel,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => deleteField(field),
      "data-test-subj": "removeFieldButton",
      "aria-label": deleteButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 17
      }
    })))));
  };
  const dataTestSubj = `${path.join('')}Field`;
  return /*#__PURE__*/_react.default.createElement("li", {
    "data-test-subj": `fieldsListItem ${dataTestSubj}`,
    ref: ref,
    "aria-label": i18nTexts.fieldListItemLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingLeft: `${indent}px`
    },
    css: [styles.field, areActionButtonsVisible && styles.fieldEnabled, isHighlighted && styles.fieldHighlighted, isDimmed && styles.fieldDim, hasDottedLine && styles.dotted],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.wrapper, treeDepth === 0 && maxNestedDepth === 0 && styles.wrapperIndent],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    css: [styles.content, !hasChildFields && !hasMultiFields && maxNestedDepth > treeDepth && styles.contentIndent],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, (hasChildFields || hasMultiFields) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.toggle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: toggleExpand,
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    "data-test-subj": "toggleExpandButton",
    "aria-label": isExpanded ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.collapseFieldButtonLabel', {
      defaultMessage: 'Collapse field {name}',
      values: {
        name: source.name
      }
    }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.expandFieldButtonLabel', {
      defaultMessage: 'Expand field {name}',
      values: {
        name: source.name
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 17
    }
  })), isMultiField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "documents",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `fieldName ${dataTestSubj}-fieldName`,
    "aria-label": i18nTexts.fieldListNameLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 13
    }
  }, source.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "aria-label": i18nTexts.fieldListTypesLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": `${dataTestSubj}-datatype`,
    "data-type-value": source.type,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 17
    }
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.multiFieldBadgeLabel', {
    defaultMessage: '{dataType} multi-field',
    values: {
      dataType: (0, _lib.getTypeLabelFromField)(source)
    }
  }) : (0, _lib.getTypeLabelFromField)(source))), isSemanticText && source.inference_id ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 19
    }
  }, source.inference_id)) : null, isShadowed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18nTexts.fieldIsShadowedLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    "data-test-subj": "isShadowedIndicator",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.shadowedBadgeLabel', {
    defaultMessage: 'Shadowed'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 13
    }
  }, renderActionButtons())))), Boolean(childFieldsArray.length) && isExpanded && /*#__PURE__*/_react.default.createElement(_fields_list.FieldsList, {
    fields: childFieldsArray,
    treeDepth: treeDepth + 1,
    state: state,
    isAddingFields: isAddingFields,
    setPreviousState: setPreviousState,
    pendingFieldsRef: pendingFieldsRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }), renderCreateField());
}
const FieldsListItem = exports.FieldsListItem = /*#__PURE__*/_react.default.memo(/*#__PURE__*/(0, _react.forwardRef)(FieldListItemComponent));