"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFieldHeaderForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../../constants");
var _field_parameters = require("../../field_parameters");
var _field_beta_badge = require("../field_beta_badge");
var _field_description_section = require("./field_description_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/edit_field/edit_field_header_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getTypeDefinition = (type, subType) => {
  if (!type) {
    return;
  }
  const typeDefinition = _constants.TYPE_DEFINITION[type];
  const hasSubType = typeDefinition.subTypes !== undefined;
  if (hasSubType) {
    if (subType) {
      return _constants.TYPE_DEFINITION[subType];
    }
    return;
  }
  return typeDefinition;
};
const EditFieldHeaderForm = exports.EditFieldHeaderForm = /*#__PURE__*/_react.default.memo(({
  defaultValue,
  isRootLevelField,
  isMultiField
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.NameParameter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.TypeParameter, {
    isRootLevelField: isRootLevelField,
    isMultiField: isMultiField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, ({
    type
  }) => {
    if (type === undefined) {
      return null;
    }
    const [fieldType] = type;
    return /*#__PURE__*/_react.default.createElement(_field_parameters.SubTypeParameter, {
      key: fieldType === null || fieldType === void 0 ? void 0 : fieldType.value,
      type: fieldType === null || fieldType === void 0 ? void 0 : fieldType.value,
      defaultValueType: defaultValue.type,
      isMultiField: isMultiField,
      isRootLevelField: isRootLevelField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 17
      }
    });
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['type', 'subType'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, ({
    type,
    subType
  }) => {
    var _type$, _subType$, _ref, _typeDefinition$descr;
    const typeDefinition = getTypeDefinition((_type$ = type[0]) === null || _type$ === void 0 ? void 0 : _type$.value, subType && ((_subType$ = subType[0]) === null || _subType$ === void 0 ? void 0 : _subType$.value));
    const description = (_ref = typeDefinition === null || typeDefinition === void 0 ? void 0 : (_typeDefinition$descr = typeDefinition.description) === null || _typeDefinition$descr === void 0 ? void 0 : _typeDefinition$descr.call(typeDefinition)) !== null && _ref !== void 0 ? _ref : null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 17
      }
    }), (typeDefinition === null || typeDefinition === void 0 ? void 0 : typeDefinition.isBeta) && /*#__PURE__*/_react.default.createElement(_field_beta_badge.FieldBetaBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 44
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_field_description_section.FieldDescriptionSection, {
      isMultiField: isMultiField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }, description));
  }));
});